/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.LauncherConfig;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.selector.ChannelIOSelector;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.selector.CounterSelector;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

public class ChannelLauncherView
extends FrameLayout {
    public static final int BOTTOM_LEFT = 0;
    public static final int BOTTOM_RIGHT = 1;
    private Context context;
    private ViewGroup root;
    private FloatingActionButton buttonFloatingAction;
    private CHTextView textBadgeCount;
    private int defaultMargin;
    private boolean visible = false;

    public ChannelLauncherView(@NonNull Context context) {
        super(context);
        this.initView(context);
    }

    public ChannelLauncherView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public ChannelLauncherView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    private void initView(final Context context) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_launcher, (ViewGroup)this, true);
        this.root = (ViewGroup)view.findViewById(R.id.ch_root_launcher_view);
        this.textBadgeCount = (CHTextView)view.findViewById(R.id.text_badge);
        this.buttonFloatingAction = (FloatingActionButton)view.findViewById(R.id.fab);
        this.buttonFloatingAction.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelIO.open(context);
            }
        });
        this.defaultMargin = context.getResources().getDimensionPixelSize(R.dimen.ch_default_channel_button_margin);
    }

    public void show() {
        this.visible = true;
        this.root.setVisibility(0);
    }

    public void hide() {
        this.visible = false;
        this.root.setVisibility(8);
    }

    public void setLauncherLayout() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(12);
        params.addRule(10, 0);
        switch (this.getGravity()) {
            case 0: {
                if (Build.VERSION.SDK_INT >= 17) {
                    params.addRule(20);
                    params.addRule(21, 0);
                }
                params.addRule(9);
                params.addRule(11, 0);
                params.setMargins(this.getXMargin(), 0, 0, this.getYMargin());
                break;
            }
            case 1: {
                if (Build.VERSION.SDK_INT >= 17) {
                    params.addRule(20, 0);
                    params.addRule(21);
                }
                params.addRule(9, 0);
                params.addRule(11);
                params.setMargins(0, 0, this.getXMargin(), this.getYMargin());
            }
        }
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.requestLayout();
        this.textBadgeCount.bringToFront();
    }

    public void setLauncherStyle() {
        if (ChannelIO.isBooted()) {
            this.buttonFloatingAction.setColorNormal(ColorSelector.getBackgroundColor());
            this.buttonFloatingAction.setColorPressed(Utils.addBlackMask(ColorSelector.getBackgroundColor()));
            this.buttonFloatingAction.setColorRipple(-1);
            this.buttonFloatingAction.setImageResource(ColorSelector.getTextColor() == -16777216 ? R.drawable.ch_plugin_balloon_black : R.drawable.ch_plugin_balloon_white);
        }
    }

    public void updateLauncherBadgeCount() {
        int count = CounterSelector.getTotalCounter();
        if (count <= 0) {
            this.textBadgeCount.setVisibility(8);
        } else {
            this.textBadgeCount.setVisibility(0);
            this.textBadgeCount.setText(Utils.getCount(count, true));
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    private int getXMargin() {
        LauncherConfig config = ChannelIOSelector.getLauncherConfig();
        if (config != null) {
            return (int)Utils.dpToPx(this.context, config.getXMargin());
        }
        return this.defaultMargin;
    }

    private int getYMargin() {
        LauncherConfig config = ChannelIOSelector.getLauncherConfig();
        if (config != null) {
            return (int)Utils.dpToPx(this.context, config.getYMargin());
        }
        return this.defaultMargin;
    }

    private int getGravity() {
        LauncherConfig config = ChannelIOSelector.getLauncherConfig();
        if (config != null) {
            return config.getLauncherGravity();
        }
        return 1;
    }
}

