package com.zoyi.channel.plugin.android.view.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;

import java.util.ArrayList;
import java.util.List;

public abstract class BaseDialog<E extends BaseDialog> extends Dialog {

  private TextView textTitle;
  private FrameLayout contentLayout;
  private LinearLayout buttonLayout;

  private Context context;

  private String title;
  @Nullable
  private View content;
  private List<Button> buttons;
  private int orientation;

  public BaseDialog(@NonNull Context context) {
    super(context);

    this.context = context;
    this.buttons = new ArrayList<>();
    this.orientation = LinearLayout.HORIZONTAL;
  }

  @Initializer
  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    //다이얼로그 배경 관련 처리
    this.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
    requestWindowFeature(Window.FEATURE_NO_TITLE);

    setContentView(R.layout.ch_dialog_base);
    textTitle = findViewById(R.id.dialog_title_txt);
    contentLayout = findViewById(R.id.dialog_content);
    buttonLayout = findViewById(R.id.dialog_button_frame);

    setDialogView();
  }

  // Create dialog view

  private void setDialogView() {
    if (title != null) {
      textTitle.setVisibility(View.VISIBLE);
      textTitle.setText(title);
    }
    if (content != null) {
      contentLayout.addView(content);
    }

    buttonLayout.setOrientation(orientation);

    for (Button button : buttons) {
      if (orientation == LinearLayout.VERTICAL) {
        button.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, 0, 1f));
      } else {
        button.setLayoutParams(new LinearLayout.LayoutParams(0, LinearLayout.LayoutParams.WRAP_CONTENT, 1f));
      }
      buttonLayout.addView(button);
    }
  }

  // Create and set buttons

  protected Button createButton(String text) {
    Button button = (Button) LayoutInflater.from(context).inflate(R.layout.ch_dialog_button, null);
    button.setText(text);
    return button;
  }

  protected void addButton(Button button) {
    buttons.add(button);
  }

  // Setter

  public E setTitle(String title) {
    this.title = title;
    return (E) this;
  }

  protected E setContent(View content) {
    this.content = content;
    return (E) this;
  }

  public E setButtonOrientation(int orientation) {
    this.orientation = orientation;
    return (E) this;
  }

  public E addButton(ButtonType type) {
    return addButton(type, null);
  }

  public E addButton(ButtonType type, @Nullable View.OnClickListener listener) {
    switch (type) {
      case CANCEL:
        return addButton(ResUtils.getString(context, "ch.common_cancel"), listener);

      default:
        return addButton(ResUtils.getString(context, "ch.common_confirm"), listener);
    }
  }

  public E addButton(String text) {
    return addButton(text, null);
  }

  public E addButton(String text, @Nullable final View.OnClickListener listener) {
    Button button = createButton(text);

    if (listener != null) {
      button.setOnClickListener(new View.OnClickListener() {
        @Override
        public void onClick(View v) {
          listener.onClick(v);
          dismiss();
        }
      });
    } else {
      button.setOnClickListener(new View.OnClickListener() {
        @Override
        public void onClick(View v) {
          dismiss();
        }
      });
    }
    addButton(button);

    return (E) this;
  }

  public E allowBackpress(boolean allow) {
    setCancelable(allow);
    return (E) this;
  }
}
