package com.zoyi.channel.plugin.android.selector;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.store.ChannelIOSettingsStore;
import com.zoyi.channel.plugin.android.store.InAppPushStore;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.store.UiStateStore;

/**
 * Created by jerry on 2018. 9. 7..
 */

public class UiStateSelector extends BaseSelector {

  public static boolean shouldShowDefaultLauncher() {
    return Store.getInstance(UiStateStore.class).getLauncherVisible();
  }

  public static boolean shouldShowClosedChat() {
    return Store.getInstance(UiStateStore.class).shouldShowClosedChat();
  }

  public static boolean shouldShowLauncher() {
    return ChannelIO.canShowLauncher() && UiStateSelector.shouldShowDefaultLauncher();
  }

  public static boolean shouldShowInAppPush() {
    ChannelPluginSettings settings = Store.getInstance(ChannelIOSettingsStore.class).getSettings();
    boolean showDefaultInAppPush = settings != null && !settings.isHideDefaultInAppPush();

    return ChannelIO.isBooted()
        && showDefaultInAppPush
        && Store.getInstance(InAppPushStore.class).get() != null;
  }

  public static boolean isMessengerVisible() {
    return Store.getInstance(UiStateStore.class).isMessengerVisible();
  }
}
