package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.Initializer;

/**
 * Created by mika on 2016. 12. 8..
 */
public class ChatMessageItem extends ConnectableMessageItem implements MessageItem {
  private Message message;

  @Initializer
  public ChatMessageItem(Message message) {
    this.message = message;
  }

  @Override
  public Long getPrimaryKey() {
    return message != null ? message.getCreatedAt() : 0L;
  }

  @Override
  public String getSecondaryKey() {
    return message != null ? message.getId() : "";
  }

  public Message getMessage() {
    return message;
  }

  public MessageType getType() {
    switch (message != null && message.getPersonType() != null ? message.getPersonType() : "") {
      case Manager.CLASSNAME:
      case Bot.CLASSNAME:
        return MessageType.HOST;

      case User.CLASSNAME:
      case Veil.CLASSNAME:
        return MessageType.GUEST;

      default:
        return MessageType.UNKNOWN;
    }
  }

  @Nullable
  public String getPersonType() {
    return message != null ? message.getPersonType() : null;
  }

  @Nullable
  public String getPersonId() {
    return message != null ? message.getPersonId() : null;
  }

  @Override
  public Long getCreatedAt() {
    return message != null ? message.getCreatedAt() : 0L;
  }

  @Override
  public boolean isSamePerson(@NonNull ConnectableMessageItem item) {
    if (item instanceof ChatMessageItem) {
      ChatMessageItem chatItem = (ChatMessageItem) item;
      return CompareUtils.isSame(getPersonType(), chatItem.getPersonType()) && CompareUtils.isSame(getPersonId(), chatItem.getPersonId());
    }
    return false;
  }
}
