/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.glide;

import com.zoyi.com.bumptech.glide.Priority;
import com.zoyi.com.bumptech.glide.load.data.DataFetcher;
import com.zoyi.com.bumptech.glide.load.model.GlideUrl;
import com.zoyi.com.bumptech.glide.util.ContentLengthInputStream;
import com.zoyi.okhttp3.Call;
import com.zoyi.okhttp3.Request;
import com.zoyi.okhttp3.Response;
import com.zoyi.okhttp3.ResponseBody;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class OkHttpStreamFetcher
implements DataFetcher<InputStream> {
    private final Call.Factory client;
    private final GlideUrl url;
    private InputStream stream;
    private ResponseBody responseBody;
    private volatile Call call;

    public OkHttpStreamFetcher(Call.Factory client, GlideUrl url) {
        this.client = client;
        this.url = url;
    }

    public InputStream loadData(Priority priority) throws Exception {
        Request.Builder requestBuilder = new Request.Builder().url(this.url.toStringUrl());
        for (Map.Entry headerEntry : this.url.getHeaders().entrySet()) {
            String key = (String)headerEntry.getKey();
            requestBuilder.addHeader(key, (String)headerEntry.getValue());
        }
        Request request = requestBuilder.build();
        this.call = this.client.newCall(request);
        Response response = this.call.execute();
        this.responseBody = response.body();
        if (!response.isSuccessful()) {
            throw new IOException("Request failed with code: " + response.code());
        }
        long contentLength = this.responseBody.contentLength();
        this.stream = ContentLengthInputStream.obtain((InputStream)this.responseBody.byteStream(), (long)contentLength);
        return this.stream;
    }

    public void cleanup() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.responseBody != null) {
            this.responseBody.close();
        }
    }

    public String getId() {
        return this.url.getCacheKey();
    }

    public void cancel() {
        Call local = this.call;
        if (local != null) {
            local.cancel();
        }
    }
}

