/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.evaluation;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.selector.GuestSelector;
import com.zoyi.channel.plugin.android.util.DeviceUtils;
import java.util.HashMap;
import java.util.Map;

public class EnvironmentInfo {
    private Map<String, Object> info = new HashMap<String, Object>(){
        {
            this.put("os", DeviceUtils.getOs());
            this.put("device", Build.MODEL);
            this.put("deviceCategory", "mobile");
            this.put("locale", PrefSupervisor.getPluginLanguage(ChannelIO.getAppContext()));
            this.put("country", GuestSelector.getCountry());
            this.put("city", GuestSelector.getCity());
            this.put("guest.id", GuestSelector.getId());
            this.put("guest.type", GuestSelector.getPersonType());
            this.put("guest.createdAt", GuestSelector.getCreatedAt());
            this.put("guest.updatedAt", GuestSelector.getUpdatedAt());
            this.put("guest.mobileNumber", GuestSelector.getMobileNumber());
            this.put("guest.name", GuestSelector.getName());
            this.put("guest.segment", GuestSelector.getSegment());
            this.put("guest.profile", GuestSelector.getProfile());
        }
    };

    public static EnvironmentInfo newInstance() {
        return new EnvironmentInfo();
    }

    private EnvironmentInfo() {
    }

    public EnvironmentInfo put(@NonNull String key, @Nullable Object value) {
        if (value != null) {
            this.info.put(key, value);
        }
        return this;
    }

    @Nullable
    public Object getValueByKey(@NonNull String key) throws Exception {
        return this.info.get(key);
    }

    @Nullable
    public Object getValueBySubKey(@NonNull String key, @NonNull String subKey) throws Exception {
        Map subInfo = (Map)this.info.get(key);
        if (subInfo != null) {
            return subInfo.get(subKey);
        }
        return null;
    }
}

