/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.utils;

import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.type.ChatNavigationState;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.selector.ColorSelector;

public class ChatResponseManager {
    public static boolean showOnlyOneManager(@Nullable Channel channel) {
        if (channel != null) {
            if (!channel.isWorking()) {
                return true;
            }
            if ("delayed".equals(channel.getExpectedResponseDelay())) {
                return true;
            }
        }
        return false;
    }

    @NonNull
    public static ChatNavigationState getNavigationState(@Nullable Channel channel) {
        if (channel == null || channel.getExpectedResponseDelay() == null) {
            return ChatNavigationState.IDLE;
        }
        if (!channel.isWorking()) {
            return ChatNavigationState.OUT_OF_WORKING;
        }
        switch (channel.getExpectedResponseDelay()) {
            case "instant": {
                return ChatNavigationState.INSTANT;
            }
            case "normal": {
                return ChatNavigationState.NORMAL;
            }
            case "delayed": {
                return ChatNavigationState.DELAYED;
            }
        }
        return ChatNavigationState.IDLE;
    }

    @Nullable
    public static String getResponseKey(@Nullable Channel channel) {
        if (channel == null || channel.getExpectedResponseDelay() == null) {
            return null;
        }
        if (!channel.isWorking()) {
            return "ch.chat.expect_response_delay.out_of_working";
        }
        switch (channel.getExpectedResponseDelay()) {
            case "instant": {
                return "ch.chat.expect_response_delay.instant";
            }
            case "normal": {
                return "ch.chat.expect_response_delay.normal";
            }
            case "delayed": {
                return "ch.chat.expect_response_delay.delayed";
            }
        }
        return null;
    }

    @Nullable
    public static String getResponseDescriptionKey(@Nullable Channel channel) {
        if (channel == null || channel.getExpectedResponseDelay() == null) {
            return null;
        }
        if (!channel.isWorking()) {
            if ("active".equals(channel.getAwayOption())) {
                return "ch.chat.expect_response_delay.out_of_working.description";
            }
            return "ch.chat.expect_response_delay.out_of_working.disabled";
        }
        switch (channel.getExpectedResponseDelay()) {
            case "instant": {
                return "ch.chat.expect_response_delay.instant.description";
            }
            case "normal": {
                return "ch.chat.expect_response_delay.normal.description";
            }
            case "delayed": {
                return "ch.chat.expect_response_delay.delayed.description";
            }
        }
        return null;
    }

    @Nullable
    public static String getShortResponseDescriptionKey(@Nullable Channel channel) {
        if (channel == null || channel.getExpectedResponseDelay() == null) {
            return null;
        }
        if (!channel.isWorking()) {
            return "ch.chat.expect_response_delay.out_of_working.short_description";
        }
        switch (channel.getExpectedResponseDelay()) {
            case "instant": {
                return "ch.chat.expect_response_delay.instant.short_description";
            }
            case "normal": {
                return "ch.chat.expect_response_delay.normal.short_description";
            }
            case "delayed": {
                return "ch.chat.expect_response_delay.delayed.short_description";
            }
        }
        return null;
    }

    @DrawableRes
    public static int getResponseSymbol(@Nullable Channel channel) {
        if (channel == null) {
            return 0;
        }
        int textColor = ColorSelector.getTextColor();
        if (!channel.isWorking()) {
            return textColor == -1 ? R.drawable.ch_plugin_offhours_w : R.drawable.ch_plugin_offhours_b;
        }
        if (channel.getExpectedResponseDelay() == null) {
            return 0;
        }
        switch (channel.getExpectedResponseDelay()) {
            case "instant": {
                return textColor == -1 ? R.drawable.ch_plugin_fast_w : R.drawable.ch_plugin_fast_b;
            }
            case "normal": {
                return textColor == -1 ? R.drawable.ch_plugin_normal_w : R.drawable.ch_plugin_normal_b;
            }
            case "delayed": {
                return textColor == -1 ? R.drawable.ch_plugin_delayed_w : R.drawable.ch_plugin_delayed_b;
            }
        }
        return 0;
    }

    @DrawableRes
    public static int getManagerOnlineSymbol(@Nullable ProfileEntity profileEntity) {
        if (profileEntity == null) {
            return 0;
        }
        if (profileEntity instanceof Manager && ((Manager)profileEntity).getOnline().booleanValue()) {
            return ColorSelector.getTextColor() == -1 ? R.drawable.ch_plugin_normal_w : R.drawable.ch_plugin_normal_b;
        }
        return 0;
    }
}

