package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.event.LanguageBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.schedulers.Schedulers;

public class CHTextView extends AppCompatTextView {

  private Context context;

  @Nullable
  private String textKey;
  @Nullable
  private Subscription subscription;

  private boolean isHTMLText;

  public CHTextView(Context context) {
    super(context);
    init(context, null);
  }

  public CHTextView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);

  }

  public CHTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  private void init(Context context, @Nullable AttributeSet attrs) {
    this.context = context;
    subscribe();
    setTypeArray(attrs);
  }

  private void setTypeArray(@Nullable AttributeSet attrs) {
    if (attrs != null) {
      TypedArray typedArray = getContext().obtainStyledAttributes(attrs, R.styleable.ChannelCustomView);
      textKey = typedArray.getString(R.styleable.ChannelCustomView_ch_text_key);
      isHTMLText = typedArray.getBoolean(R.styleable.ChannelCustomView_ch_html_text, false);
      setTextByKey(textKey);
    }
  }

  private void subscribe() {
    subscription = RxBus.observable().subscribe(new Action1<Object>() {
          @Override
          public void call(Object o) {
            onReceiveEvent(o);
          }
        });
  }

  private void onReceiveEvent(Object object) {
    if (object instanceof LanguageBus && textKey != null) {
      setTextByKey(textKey);
    }
  }

  public void setTextByKey(@Nullable String key) {
    this.textKey = key;

    if (isHTMLText && key != null) {
      super.setText(Utils.getHtmlFormattedText(ResUtils.getString(context, key)));
    } else {
      super.setText(ResUtils.getString(context, key));
    }
  }

  public void setTextByKey(@Nullable String key, @ColorRes int colorId) {
    setTextByKey(key);
    setTextColor(ContextCompat.getColor(context, colorId));
  }

  public void setText(String text, @ColorRes int colorId) {
    super.setText(text);
    setTextColor(ContextCompat.getColor(context, colorId));
  }

  @Override
  protected void onDetachedFromWindow() {
    if (subscription != null && !subscription.isUnsubscribed()) {
      subscription.unsubscribe();
    }
    super.onDetachedFromWindow();
  }
}
