package com.zoyi.channel.plugin.android.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;

import java.net.NetworkInterface;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

/**
 * Created by mika on 2018. 7. 4..
 */

public class DeviceUtils {

  @SuppressLint("HardwareIds")
  public static String getWId(Context context) {
    try {
      List<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
      String interfaceName = "wlan0";

      for (NetworkInterface networkInterface : interfaces) {
        if (!networkInterface.getName().equalsIgnoreCase(interfaceName)) {
          continue;
        }
        byte[] mac = networkInterface.getHardwareAddress();
        if (mac == null) {
          return null;
        }
        StringBuilder buf = new StringBuilder();
        for (byte aMac : mac) {
          buf.append(String.format("%02X:", aMac));
        }
        if (buf.length() > 0) {
          buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString().trim();
      }
    } catch (Exception ignored) {
    }
    return null;
  }

  public static String getOs() {
    return String.format(Locale.US, "Android %d", Build.VERSION.SDK_INT);
  }
}
