package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.PushBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;

/**
 * Created by mika on 2018. 11. 30..
 */

public class PushBotMessageHolder extends ContentMessageHolder {

  public static PushBotMessageHolder newInstance(
      ViewGroup parent,
      @Nullable OnMessageContentClickListener onMessageContentClickListener) {
    return new PushBotMessageHolder(
        getItemView(parent, MessageType.PUSH_BOT),
        MessageType.PUSH_BOT,
        onMessageContentClickListener);
  }

  private PushBotMessageHolder(
      View itemView,
      MessageType messageType,
      @Nullable OnMessageContentClickListener onMessageContentClickListener) {
    super(itemView, messageType, onMessageContentClickListener);
  }

  public void bind(PushBotMessageItem item) {
    super.bind(item.getMessage(), MessageType.PUSH_BOT, false);
    setHostMessageText(item.getMessage().getFormattedSpanMessage(), false);

    if (item.getPushBotItem().getImageThumb() != null) {
      setImage(item.getPushBotItem().getImageThumb());
    }
  }
}
