package com.zoyi.channel.plugin.android.activity.chat;

import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageButton;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnNewMessageAlertClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.view.ChatHeaderView;
import com.zoyi.channel.plugin.android.activity.chat.view.ChatNavigationView;
import com.zoyi.channel.plugin.android.activity.chat.view.NewMessageAlertView;
import com.zoyi.channel.plugin.android.activity.chat.view.overlayheader.OnHeaderStateChangeListener;
import com.zoyi.channel.plugin.android.activity.chat.view.overlayheader.OverlayHeaderCallback;
import com.zoyi.channel.plugin.android.activity.chat.view.overlayheader.OverlayHeaderRecyclerView;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumStorage;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerActivity;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.activity.video.VideoViewerActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.Person;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.CounterSelector;
import com.zoyi.channel.plugin.android.selector.UserChatSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store.ImageFileStore;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.store.TranslationStore;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.util.message_format.type.LinkType;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.*;
import com.zoyi.channel.plugin.android.view.layout.BigBar.MenuPosition;
import com.zoyi.channel.plugin.android.view.layout.MenuButton.ActionType;
import com.zoyi.channel.plugin.android.view.layout.MenuButton.MenuState;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;

import java.util.concurrent.TimeUnit;

/**
 * Created by mika on 2016. 12. 7..
 */
public class ChatActivity
    extends BaseActivity
    implements
    ChatContract.View,
    EditTextChangedListener,
    View.OnClickListener,
    OnNewMessageAlertClickListener,
    OverlayHeaderCallback,
    OnHeaderStateChangeListener {

  private OverlayHeaderRecyclerView headerRecyclerView;

  private WatchedEditText editChat;
  private ImageButton imageSend;
  private View layoutInput;
  private NewMessageAlertView newMessageAlertView;
  private CHTextView disabledInputText;

  private ChatNavigationView chatNavigation;

  private BottomFloatingActionLayout bottomFloatingActionLayout;
  private NewChatButton newChatButton;
  @Nullable
  private BigBar bigBar;

  @Nullable
  private ChatHeaderView chatHeaderView;

  private LinearLayoutManager layoutManager;
  private TypingManager typingManager;

  private ChatContract.Presenter presenter;

  private ChatAdapter adapter;

  @Nullable
  private Subscription countSubscription;

  private boolean exit = false;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.ch_plugin_activity_chat);

    String chatId = null;

    if (getIntent() != null) {
      chatId = getIntent().getStringExtra(Const.EXTRA_CHAT_ID);
    }
    bigBar = getBigBar();

    initBigBar();

    FragmentManager fm = getSupportFragmentManager();

    presenter = new ChatPresenter(this);
    adapter = new ChatAdapter(TextUtils.isEmpty(chatId));

    presenter.setView(this);
    presenter.setAdapterModel(adapter);
    presenter.setAdapterView(adapter);
    presenter.setChatId(chatId);

    newMessageAlertView = (NewMessageAlertView) findViewById(R.id.view_new_message_alert);
    newMessageAlertView.setListener(this);

    headerRecyclerView = (OverlayHeaderRecyclerView) findViewById(R.id.recycler_header);

    imageSend = findViewById(R.id.iv_chat_send);
    disabledInputText = findViewById(R.id.text_disabled_input);
    editChat = findViewById(R.id.edit_chat);
    layoutInput = findViewById(R.id.layout_input);

    newChatButton = findViewById(R.id.ch_button_new_chat);
    bottomFloatingActionLayout = findViewById(R.id.ch_layout_bottom_floating_action);

    typingManager = new TypingManager(chatId, editChat);

    layoutManager = new LinearLayoutManager(this);
    layoutManager.setStackFromEnd(true);

    chatNavigation = new ChatNavigationView(this);

    headerRecyclerView.getRecyclerView().setLayoutManager(layoutManager);
    headerRecyclerView.getRecyclerView().setAdapter(adapter);
    headerRecyclerView.getRecyclerView().setItemAnimator(null);
    headerRecyclerView.addBannerView(chatNavigation);
    headerRecyclerView.setCallback(this);
    headerRecyclerView.setListener(this);
    headerRecyclerView.getRecyclerView().addOnScrollListener(new InfiniteScrollListener(
        layoutManager,
        InfiniteScrollListener.TOP,
        headerRecyclerView.getRecyclerView()) {
      @Override
      public void scrolledInList() {
        bottomFloatingActionLayout.hide();
      }

      @Override
      public void scrollAttachedToBottom() {
        newMessageAlertView.hide();
        bottomFloatingActionLayout.show();
      }

      @Override
      public void refresh() {
        presenter.fetchBackwardMessages();
      }
    });

    bottomFloatingActionLayout.setRecyclerView(headerRecyclerView.getRecyclerView());

    findViewById(R.id.button_attach).setOnClickListener(this);

    imageSend.setOnClickListener(this);

    editChat.setWatchedTextChangedListener(this);
    editChat.setOnFocusChangeListener(new View.OnFocusChangeListener() {
      @Override
      public void onFocusChange(View v, boolean hasFocus) {
        adapter.setChatEditTextFocus(hasFocus);
      }
    });
    editChat.setText(PrefSupervisor.getStoredMessage(this));
    PrefSupervisor.clearStoredMessage(this);

    newChatButton.setClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        setResult(Const.RESULT_CHAT_OPEN_NEW_CHAT);
        finish();
      }
    });

    setDisabledInputBoxView(false);

//    BackgroundToucher.makeKeyboardEvent(this, headerRecyclerView.getRecyclerView(), editChat);
    Store.getInstance(ImageFileStore.class).clear();

    setBigbarStyle();

    presenter.init(chatId);

    if (SocketManager.isError()) {
      setReconnectVisibility(true);
    }

    bindChannel(ChannelSelector.getCurrentChannel());
    bindUserChat(UserChatSelector.get(chatId));
  }

  @Override
  protected void onDestroy() {
    if (presenter != null) {
      presenter.release();
    }
    if (countSubscription != null && !countSubscription.isUnsubscribed()) {
      countSubscription.unsubscribe();
    }
    Store.getInstance(TranslationStore.class).clearData();
    Store.getInstance(ImageFileStore.class).clear();
    super.onDestroy();
  }

  @Override
  public void finish() {
    if (presenter != null && presenter.getChatId() != null) {
      presenter.leaveChat();
    }
    super.finish();
  }

  private void initBigBar() {
    if (bigBar != null) {
      chatHeaderView = new ChatHeaderView(this);

      bigBar.withActivity(this)
          .addMenu(
              ActionType.SETTINGS,
              MenuPosition.LEFT,
              MenuState.HIDDEN)
          .addMenu(
              ActionType.BACK,
              MenuPosition.LEFT,
              MenuState.HIDDEN)
          .addText(MenuPosition.LEFT)
          .addMenu(ActionType.REFRESH, MenuPosition.RIGHT, MenuState.HIDDEN)
          .addMenu(ActionType.EXIT, MenuPosition.RIGHT)
          .setHeaderView(chatHeaderView)
          .build();
    }

    refreshChatCount(true);
    refreshMenuButton();
  }

  private void refreshChatCount(boolean force) {
    if (force) {
      if (bigBar != null) {
        bigBar.setText(CounterSelector.getTotalCounter());
      }
    } else {
      if (countSubscription != null && !countSubscription.isUnsubscribed()) {
        countSubscription.unsubscribe();
      }
      countSubscription = Observable.timer(600, TimeUnit.MILLISECONDS)
          .observeOn(AndroidSchedulers.mainThread())
          .subscribe(new Action1<Long>() {
            @Override
            public void call(Long aLong) {
              if (bigBar != null) {
                bigBar.setText(CounterSelector.getTotalCounter());
              }
            }
          });
    }
  }

  private void refreshMenuButton() {
    if (bigBar != null) {
      if (UserChatSelector.getUserChatCount() > 0 || (presenter != null && presenter.getUserChat() != null)) {
        bigBar.setMenuState(ActionType.BACK, MenuState.VISIBLE);
        bigBar.setMenuState(ActionType.SETTINGS, MenuState.HIDDEN);
      } else {
        bigBar.setMenuState(ActionType.BACK, MenuState.HIDDEN);
        bigBar.setMenuState(ActionType.SETTINGS, MenuState.VISIBLE);
      }
    }
  }

  private void setBigbarStyle() {
    Channel channel = ChannelSelector.getCurrentChannel();
    if (channel != null && bigBar != null) {
      bigBar.setTitle(channel.getName());
    }
  }

  private void setDisabledInputBoxView(boolean isSocketEvent) {
    Channel channel = ChannelSelector.getCurrentChannel();

    if (channel != null) {
      if (isSocketEvent) {
        if (channel.isWorking() || Const.AWAY_OPTION_ACTIVE.equals(channel.getAwayOption())) {
          setDisabledInputBoxVisibility(false);
        }
      } else {
        if (!channel.isWorking() && Const.AWAY_OPTION_DISABLED.equals(channel.getAwayOption())) {
          setDisabledInputBoxVisibility(true);
        } else {
          setDisabledInputBoxVisibility(false);
        }
      }
    } else {
      setDisabledInputBoxVisibility(false);
    }
  }

  private void setDisabledInputBoxVisibility(boolean isDisabled) {
    disabledInputText.setVisibility(UIUtils.getVisible(isDisabled, true));
    layoutInput.setVisibility(UIUtils.getVisible(!isDisabled, true));
  }

  @Override
  public void onLoadUserChat(@Nullable UserChat userChat) {
    chatNavigation.bindUserChat(userChat);

    if (userChat == null) {
      headerRecyclerView.showBanner(true);
    }

    if (userChat != null) {
      typingManager.setChatId(userChat.getId());
    }

    if (bigBar != null) {
      bigBar.setOnClickListener(this);
    }

    refreshMenuButton();
  }

  @Override
  public void updateBackwardId(@Nullable String backwardId) {
//    chatList.setBackwardId(backwardId);
    // TODO
  }

  @Override
  public void setInputLayoutVisibility(@Nullable String userChatState) {
    if (userChatState != null) {
      Views.setVisibility(layoutInput, CompareUtils.exists(
          userChatState,
          Const.USER_CHAT_STATE_READY,
          Const.USER_CHAT_STATE_OPEN,
          Const.USER_CHAT_STATE_FOLLOWING,
          Const.USER_CHAT_STATE_HOLDING,
          Const.USER_CHAT_STATE_CONTINUE_CHAT));

      Views.setVisibility(newChatButton, CompareUtils.isSame(userChatState, Const.USER_CHAT_STATE_CLOSED));

      if (CompareUtils.exists(userChatState, Const.USER_CHAT_STATE_SOLVED, Const.USER_CHAT_STATE_CLOSED)) {
        hideKeyboard(editChat);
      }

      disabledInputText.setVisibility(View.GONE);
    }
  }

  @Override
  public void showRefreshButton() {
    if (bigBar != null) {
      bigBar.setMenuState(ActionType.REFRESH, MenuState.VISIBLE);
    }
  }

  @Override
  public boolean isMovableToBottomPosition() {
    int lastPosition = layoutManager.findLastVisibleItemPosition();
    return lastPosition <= adapter.getItemCount() - 2 && lastPosition >= adapter.getItemCount() - 4;
  }

  @Override
  public boolean isBottomPosition() {
    return layoutManager.findLastCompletelyVisibleItemPosition() >= adapter.getItemCount() - 2;
  }

  @Override
  public void scrollToPosition(int position) {
    layoutManager.scrollToPosition(position);
  }

  @Override
  public void scrollToBottom(boolean force) {
    if (layoutManager.findLastCompletelyVisibleItemPosition() == adapter.getItemCount() - 2 || force) {
      layoutManager.scrollToPosition(adapter.getItemCount() - 1);
    }
  }

  @Override
  protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    super.onActivityResult(requestCode, resultCode, data);
    switch (requestCode) {
      case Const.PHOTO_REQUEST_CODE:
        if (resultCode == Const.PHOTO_RESULT_CODE) {
          presenter.sendImageFiles(data.getStringArrayListExtra(Const.PHOTO_INTENT_KEY));
        }
        break;

      case Const.REQUEST_PHOTO_ALBUM:
        PhotoAlbumStorage.getInstance().release();
        break;

      case Const.REQUEST_PLUGIIN_SETTINGS:
        if (resultCode == Const.RESULT_CHAT_OPTION_CHANGED) {
          setResult(Const.RESULT_CHAT_OPTION_CHANGED);
        }
        break;
    }
  }

  @Override
  protected void receiveRxEvent(Object o) {
    super.receiveRxEvent(o);
  }

  @Override
  public void receiveCommand(Command command, @Nullable Object object) {
    presenter.receiveCommand(command, object);
  }

  @Override
  public void receiveData(Entity entity, boolean upsert) {
    presenter.receiveData(entity, upsert);
  }

  @Override
  public void receiveStoreEvent(StoreType storeType, UpdateType updateType, @Nullable Entity entity) {
    switch (storeType) {
      case USER:
      case VEIL:
        refreshChatCount(false);
        break;

      case USER_CHAT:
        refreshMenuButton();
        UserChat userChat = (UserChat) entity;

        if (userChat == null) {
          return;
        }

        if (CompareUtils.isSame(userChat.getId(), presenter.getChatId())) {
          setInputLayoutVisibility(userChat.getState());
          bottomFloatingActionLayout.bindUserChatState(userChat.getState());
        }

        // Set title & top navigation
        bindUserChat(userChat);
        chatNavigation.bindUserChat(userChat);

        break;

      case CHANNEL:
        if (entity != null) {
          bindChannel((Channel) entity);
        }
        break;
    }
  }

  @Override
  public void receiveTyping(Typing typing) {
    if (typing != null
        && typing.isOther()
        && typing.isSameChat(presenter.getChatId(), UserChat.CLASSNAME)) {
      typingManager.refreshTypingExpiresAt(typing);

      presenter.receiveTyping(typing);
    }
  }

  @Override
  public void receiveLanguageEvent() {
    presenter.receiveLanguageEvent();
  }

  @Override
  public void optionClicked(ActionType actionType) {
    switch (actionType) {
      case REFRESH:
        presenter.refresh();
        break;
      case SETTINGS:
        IntentUtils.setNextActivity(this, SettingsActivity.class)
            .setTransition(Transition.SLIDE_FROM_BOTTOM)
            .startActivityForResult(Const.REQUEST_PLUGIIN_SETTINGS);
        break;
      case BACK:
        onBackPressed();
        break;
      case EXIT:
        goToMain();
        break;
    }
  }

  @Override
  public void setRefreshVisibility(boolean showRefresh) {
    if (bigBar != null) {
      bigBar.setMenuState(ActionType.REFRESH, showRefresh ? MenuState.VISIBLE : MenuState.HIDDEN);
    }
  }

  @Override
  public void setReconnectVisibility(boolean show) {
//    topNavFragment.setReconnectVisibility(show);
    // TODO
  }

  @Override
  public void setChannel(Channel channel) {
    bindChannel(channel);
    setDisabledInputBoxView(true);
    chatNavigation.bindChannel(channel);
  }

  @Override
  public void processNewMessage(@Nullable ProfileEntity profileEntity, @Nullable Message message) {
    if (profileEntity == null || message == null || message.getLog() != null) {
      return;
    }

    if (layoutManager.canScrollVertically() && !isBottomPosition()) {
      newMessageAlertView.show(profileEntity);
    }
  }

  @Override
  public void onNewMessageAlertClick() {
    scrollToBottom(true);
  }

  @Override
  public void setLastResponseManager(@Nullable Person person) {
//    topNavFragment.setLastResponseManager(person);
  }

  @Override
  public void onRemovedChat() {
    finish();
  }

  @Override
  public void onWatchedTextChanged(String s) {
    imageSend.setEnabled(!TextUtils.isEmpty(s.trim()));
  }

  @Override
  public void onClick(View v) {
    int id = v.getId();

    if (id == R.id.button_attach) {
      hideKeyboard(editChat);
      IntentUtils.setNextActivity(ChatActivity.this, PhotoPickerActivity.class)
          .startActivityForResult(Const.PHOTO_REQUEST_CODE);
    }
    if (id == R.id.iv_chat_send) {
      presenter.sendTextMessage(editChat.getString());
      editChat.setText("");
    }
    if (id == R.id.big_bar) {
      headerRecyclerView.toggleBanner();
    }
  }

  @Override
  public void onFileDownload(File file) {
    if (file.getType() != null && file.getType().startsWith("video")) {
      IntentUtils.setNextActivity(this, VideoViewerActivity.class)
          .putExtra(Const.EXTRA_FILE_NAME, file.getName())
          .putExtra(Const.EXTRA_URL, file.getUrl())
          .startActivity();
    } else {
      IntentUtils.setNextActivity(this, DownloadActivity.class)
          .putExtra(Const.EXTRA_URL, file.getUrl())
          .putExtra(Const.EXTRA_FILE_NAME, file.getFilename())
          .putExtra(Const.EXTRA_IMAGE, file.isImage())
          .setTransition(Transition.NONE)
          .startActivity();
    }
  }

  @Override
  public void onShowPhotoAlbum(File file) {
    IntentUtils.setNextActivity(this, PhotoAlbumActivity.class)
        .putExtra(Const.EXTRA_FILE_ID, file.getId())
        .startActivityForResult(Const.REQUEST_PHOTO_ALBUM);
  }

  @Override
  public void onWebDescriptionClick(String url) {
    Executor.executeLinkAction(this, url, LinkType.URL);
  }

  @Override
  public void onChangeProfileMessageFocus(boolean hasFocus) {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
      layoutInput.setBackground(ContextCompat.getDrawable(this,
          hasFocus ? R.drawable.ch_plugin_chat_disabled_input_box_bg : R.drawable.ch_plugin_chat_input_box_bg));
    } else {
      layoutInput.setBackgroundDrawable(ContextCompat.getDrawable(this,
          hasFocus ? R.drawable.ch_plugin_chat_disabled_input_box_bg : R.drawable.ch_plugin_chat_input_box_bg));
    }
  }

  @Override
  public void onBackPressed() {
    if (!UserChatSelector.isEmpty() || (presenter != null && presenter.getUserChat() != null)) {
      finish();
    } else {
      goToMain();
    }
  }

  private void goToMain() {
    exit = true;

    setResult(Const.RESULT_CHAT_GO_TO_MAIN);
    finish();
  }

  @Override
  public void requestFocusEditText() {
    editChat.requestFocus();
  }

  @Override
  public void sendingMessageClicked(final SendingMessageItem item) {
    final AlertDialog dialog = new AlertDialog.Builder(this)
        .setMessage(ResUtils.getString(this, "ch.chat.resend.description"))
        .setPositiveButton(ResUtils.getString(this, "ch.chat.retry_sending_message"), new DialogInterface.OnClickListener() {
          @Override
          public void onClick(DialogInterface dialog, int which) {
            presenter.resend(item);
          }
        })
        .setNegativeButton(ResUtils.getString(this, "ch.chat.resend.cancel"), null)
        .setNeutralButton(ResUtils.getString(this, "ch.chat.delete"), new DialogInterface.OnClickListener() {
          @Override
          public void onClick(DialogInterface dialog, int which) {
            presenter.removeFailedItem(item);
          }
        })
        .setCancelable(true)
        .create();

    dialog.setOnShowListener(new DialogInterface.OnShowListener() {
      @Override
      public void onShow(DialogInterface args) {
        int dark = ContextCompat.getColor(ChatActivity.this, R.color.ch_dark);
        int cobalt = ContextCompat.getColor(ChatActivity.this, R.color.ch_cobalt);

        dialog.getButton(AlertDialog.BUTTON_POSITIVE).setTextColor(cobalt);
        dialog.getButton(AlertDialog.BUTTON_NEGATIVE).setTextColor(dark);
        dialog.getButton(AlertDialog.BUTTON_NEUTRAL).setTextColor(dark);
      }
    });
    dialog.show();
  }

  @Override
  @AnimRes
  protected int getExistAnimOfFinish() {
    if (UserChatSelector.isEmpty() || exit) {
      return R.anim.ch_plugin_slide_out_bottom;
    }
    return R.anim.ch_plugin_slide_out_right;
  }

  @Override
  public boolean canScrollTop() {
    return presenter.getBackwardId() != null && !Const.MESSAGE_ID_MAX.equals(presenter.getBackwardId());
  }

  @Override
  public void bindUserChat(@Nullable UserChat userChat) {
    if (chatHeaderView != null) {
      chatHeaderView.bindUserChat(userChat);
    }
    if (chatNavigation != null) {
      chatNavigation.bindUserChat(userChat);
    }
  }

  private void bindChannel(@Nullable Channel channel) {
    if (chatHeaderView != null) {
      chatHeaderView.bindChannel(channel);
    }
    if (chatNavigation != null) {
      chatNavigation.bindChannel(channel);
    }
  }

  @Override
  public void onBannerShow() {
    if (chatHeaderView != null) {
      chatHeaderView.setExpand(true);
    }
  }

  @Override
  public void onBannerHide() {
    if (chatHeaderView != null) {
      chatHeaderView.setExpand(false);
    }
  }
}
