/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.producers;

import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SingleDelayedProducer<T>
extends AtomicInteger
implements Producer {
    private static final long serialVersionUID = -2873467947112093874L;
    final Subscriber<? super T> child;
    T value;
    static final int NO_REQUEST_NO_VALUE = 0;
    static final int NO_REQUEST_HAS_VALUE = 1;
    static final int HAS_REQUEST_NO_VALUE = 2;
    static final int HAS_REQUEST_HAS_VALUE = 3;

    public SingleDelayedProducer(Subscriber<? super T> child) {
        this.child = child;
    }

    @Override
    public void request(long n) {
        block5: {
            int s;
            if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required");
            }
            if (n == 0L) {
                return;
            }
            while ((s = this.get()) == 0) {
                if (!this.compareAndSet(0, 2)) {
                    continue;
                }
                break block5;
            }
            if (s == 1 && this.compareAndSet(1, 3)) {
                SingleDelayedProducer.emit(this.child, this.value);
            }
        }
    }

    public void setValue(T value) {
        block3: {
            int s;
            while ((s = this.get()) == 0) {
                this.value = value;
                if (!this.compareAndSet(0, 1)) {
                    continue;
                }
                break block3;
            }
            if (s == 2 && this.compareAndSet(2, 3)) {
                SingleDelayedProducer.emit(this.child, value);
            }
        }
    }

    private static <T> void emit(Subscriber<? super T> c, T v) {
        if (c.isUnsubscribed()) {
            return;
        }
        try {
            c.onNext(v);
        }
        catch (Throwable e) {
            Exceptions.throwOrReport(e, c, v);
            return;
        }
        if (c.isUnsubscribed()) {
            return;
        }
        c.onCompleted();
    }
}

