package com.zoyi.channel.plugin.android.selector;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.store.PluginStore;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.util.ResUtils;

/**
 * Created by mika on 2018. 6. 18..
 */

public class PluginSelector extends BaseSelector {

  @Nullable
  public static Plugin getPlugin() {
    return Store.getInstance(PluginStore.class).get();
  }

  @Nullable
  public static String getPluginKey() {
    Plugin plugin = getPlugin();

    if (plugin != null) {
      return plugin.getKey();
    }
    return null;
  }

  @Nullable
  public static String getPluginId() {
    Plugin plugin = getPlugin();

    if (plugin != null) {
      return plugin.getId();
    }
    return null;
  }

  @NonNull
  public static String getWelcomeMessage(@Nullable Context context) {
    Plugin plugin = Store.getInstance(PluginStore.class).get();
    String guestName = GuestSelector.isNamed() ? GuestSelector.getName() : null;
    String language = PrefSupervisor.getPluginLanguage(context);

    if (plugin != null && language != null) {
      if (guestName != null) {
        return plugin.getWelcomeNamedI18n().get(language).replace("${name}", guestName);
      }
      return plugin.getWelcomeI18n().get(language);
    }
    return ResUtils.getString(context, "ch.scripts.welcome_veil.default");
  }
}
