package com.zoyi.channel.plugin.android.activity.userchat_list.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;

/**
 * Created by jerry on 2018. 11. 27..
 */

public class PushBotChatItem implements ChatListItem {

  @NonNull
  private PushBotItem pushBotItem;

  public PushBotChatItem(@NonNull PushBotItem pushBotItem) {
    this.pushBotItem = pushBotItem;
  }

  @Override
  public Long getPrimaryKey() {
    return pushBotItem.getCreatedAt();
  }

  @Override
  public String getSecondaryKey() {
    return pushBotItem.getId();
  }

  @NonNull
  @Override
  public String getId() {
    return pushBotItem.getId();
  }

  @Override
  public ProfileEntity getProfile() {
    return pushBotItem.getProfile();
  }

  @Override
  public String getAlert() {
    String alert = Integer.toString(pushBotItem.getAlertCount());

    if (Const.STRING_ZERO.equals(alert)) {
      return "";
    } else {
      return alert;
    }
  }

  @Override
  public String getUpdatedDate() {
    return TimeUtils.get(pushBotItem.getCreatedAt());
  }

  @Override
  public ChatListItemType getItemType() {
    return ChatListItemType.PUSH_BOT_CHAT;
  }

  public String getFormattedMessageText() {
    return pushBotItem.getFormattedSpanMessage().toString();
  }
}
