/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatActivity2;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListAdapter;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListPresenter;
import com.zoyi.channel.plugin.android.activity.userchat_list.contract.UserChatListContract;
import com.zoyi.channel.plugin.android.activity.userchat_list.listener.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.ChatListItem;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.PushBotChatItem;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.selector.PushBotSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.channel.plugin.android.view.handler.AlertDialogListener;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.BottomFloatingActionLayout;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;

public class UserChatListActivity
extends BaseActivity
implements View.OnClickListener,
UserChatListContract.View,
OnUserChatClickListener {
    private View rootView;
    private View contentLayout;
    private View emptyLayout;
    private View reconnectLayout;
    private RecyclerView chatList;
    private BottomFloatingActionLayout bottomFloatingActionLayout;
    private FloatingActionButton fab;
    private LinearLayoutManager layoutManager;
    private UserChatListAdapter adapter;
    private UserChatListContract.Presenter presenter;
    @Nullable
    private String redirectChatId;
    @Nullable
    private String redirectPushBotId;
    protected boolean animateOnInit = true;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_user_chat_list);
        if (this.getIntent() != null) {
            this.redirectChatId = this.getIntent().getStringExtra("chatId");
            this.redirectPushBotId = this.getIntent().getStringExtra("pushBotId");
            this.animateOnInit = this.getIntent().getBooleanExtra("animated", true);
        }
        this.rootView = this.findViewById(R.id.root_view);
        this.contentLayout = this.findViewById(R.id.layout_user_chat_list_content);
        this.emptyLayout = this.findViewById(R.id.layout_empty);
        this.reconnectLayout = this.findViewById(R.id.layout_reconnect);
        this.fab = (FloatingActionButton)this.findViewById(R.id.fab);
        this.chatList = (RecyclerView)this.findViewById(R.id.recycler_view);
        this.bottomFloatingActionLayout = (BottomFloatingActionLayout)this.findViewById(R.id.ch_layout_chat_list_bottom_frame);
        this.fab.setOnClickListener(this);
        if (this.bigBar != null) {
            this.bigBar.withActivity(this).addMenu(MenuButton.ActionType.SETTINGS, BigBar.MenuPosition.LEFT).addMenu(MenuButton.ActionType.REFRESH, BigBar.MenuPosition.RIGHT, MenuButton.MenuState.HIDDEN).addMenu(MenuButton.ActionType.EXIT, BigBar.MenuPosition.RIGHT).build();
        }
        this.adapter = new UserChatListAdapter();
        this.adapter.setOnUserChatClickListener(this);
        this.presenter = new UserChatListPresenter((Context)this);
        this.presenter.setView(this);
        this.presenter.setAdapterView(this.adapter);
        this.presenter.setAdapterModel(this.adapter);
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.chatList.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.chatList.setAdapter((RecyclerView.Adapter)this.adapter);
        this.chatList.setItemAnimator(null);
        this.chatList.getRecycledViewPool().setMaxRecycledViews(0, 40);
        this.chatList.addOnScrollListener((RecyclerView.OnScrollListener)new InfiniteScrollListener(this.layoutManager, 1, this.chatList){

            @Override
            public void scrolledInList() {
                UserChatListActivity.this.bottomFloatingActionLayout.hide();
            }

            @Override
            public void scrollAttachedToBottom() {
                UserChatListActivity.this.bottomFloatingActionLayout.show();
            }

            @Override
            public void refresh() {
            }
        });
        this.bottomFloatingActionLayout.setRecyclerView(this.chatList);
        this.setStyle();
        if (SocketManager.isError()) {
            this.setErrorView(true);
        }
        this.presenter.refresh();
    }

    private void setStyle() {
        Channel channel = ChannelSelector.getCurrentChannel();
        Plugin plugin = PluginSelector.getPlugin();
        if (channel == null || plugin == null) {
            this.finish();
        } else {
            if (this.bigBar != null) {
                this.bigBar.setTitle(channel.getName());
            }
            this.setFabTheme();
            this.fab.attachToRecyclerView(this.chatList);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        block0 : switch (requestCode) {
            case 3002: {
                if (resultCode == 23) {
                    this.presenter.refresh();
                }
                this.presenter.redrawList();
                break;
            }
            case 21: {
                switch (resultCode) {
                    case 22: {
                        this.startChat(null, false, true, true);
                        break block0;
                    }
                    case 23: {
                        this.presenter.refresh();
                        break block0;
                    }
                    case 24: {
                        this.finish();
                    }
                }
            }
        }
    }

    @Override
    protected void onStart() {
        ChannelPushManager.sendTokenToChannelIO(ChannelIO.getAppContext());
        this.onUserChatsUpdate(this.adapter.getItemCount(), false);
        super.onStart();
    }

    private void setFabTheme() {
        this.fab.setColorNormal(ColorSelector.getBackgroundColor());
        this.fab.setColorPressed(Utils.addBlackMask(ColorSelector.getBackgroundColor()));
        this.fab.setColorRipple(-1);
        this.fab.setImageResource(ColorSelector.getTextColor() == -16777216 ? R.drawable.ch_plugin_ic_add_black_24dp : R.drawable.ch_plugin_ic_add_white_24dp);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.fab) {
            this.startChat(null, false, true, false);
        }
    }

    @Override
    public void optionClicked(MenuButton.ActionType actionType) {
        switch (actionType) {
            case REFRESH: {
                if (this.bigBar != null) {
                    this.bigBar.setMenuState(MenuButton.ActionType.REFRESH, MenuButton.MenuState.HIDDEN);
                }
                this.presenter.refresh();
                break;
            }
            case SETTINGS: {
                IntentUtils.setNextActivity((Context)this, SettingsActivity.class).setTransition(Transition.SLIDE_FROM_BOTTOM).startActivityForResult(3002);
            }
        }
        super.optionClicked(actionType);
    }

    @Override
    public void userChatsFetched(boolean init) {
        this.onUserChatsUpdate(this.adapter.getItemCount(), init);
        if (this.redirectChatId != null) {
            ChatListItem chatListItem = this.presenter.getUserChatItem(this.redirectChatId);
            if (chatListItem != null) {
                this.startRedirectChat(chatListItem);
            }
        } else if (this.redirectPushBotId != null) {
            PushBotItem pushBotItem = PushBotSelector.get(this.redirectPushBotId);
            if (pushBotItem != null) {
                this.startRedirectChat(new PushBotChatItem(pushBotItem));
            }
        } else if (this.adapter.getItemCount() <= 1 && init) {
            if (this.adapter.getItemCount() == 0) {
                this.startRedirectChat(null);
            } else {
                this.startRedirectChat(this.adapter.getFirstChatListItem());
            }
        }
        this.redirectChatId = null;
        this.redirectPushBotId = null;
    }

    private void startRedirectChat(@Nullable ChatListItem chatListItem) {
        this.startChat(chatListItem, true, false, false);
    }

    private void startChat(@Nullable ChatListItem chatListItem, boolean redirect, boolean animate, boolean force) {
        Transition transition = !animate ? Transition.NONE : (redirect ? Transition.SLIDE_FROM_BOTTOM : Transition.SLIDE_FROM_RIGHT);
        if (force || this.isActivityFocused) {
            this.presenter.fetchPreloadData(chatListItem, transition);
        }
    }

    @Override
    public void setErrorView(boolean visible) {
        if (this.bigBar != null) {
            this.bigBar.setMenuState(MenuButton.ActionType.REFRESH, visible ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.HIDDEN);
        }
        Views.setVisibility(this.contentLayout, !visible);
        Views.setVisibility(this.reconnectLayout, visible);
    }

    private void showDeleteUserChatDialog(final @NonNull ChatListItem chatListItem) {
        UIUtils.showAlertDialog((Context)this, ResUtils.getString((Context)this, "ch.chat.delete_description"), true, new AlertDialogListener(){

            @Override
            public void onPositive() {
                switch (chatListItem.getItemType()) {
                    case USER_CHAT: {
                        UserChatListActivity.this.presenter.removeUserChat(chatListItem.getId());
                        break;
                    }
                    case PUSH_BOT_CHAT: {
                        UserChatListActivity.this.presenter.removePushBotChat(chatListItem.getId());
                    }
                }
            }
        });
    }

    @Override
    public void completeRemoveChat() {
        this.hideProgress();
        this.onUserChatsUpdate(this.adapter.getItemCount(), false);
    }

    @Override
    public void successFetchPreloadData(@Nullable ChatListItem chatListItem, Transition transition) {
        String chatId = null;
        String pushBotId = null;
        if (chatListItem != null) {
            switch (chatListItem.getItemType()) {
                case USER_CHAT: {
                    chatId = chatListItem.getId();
                    break;
                }
                case PUSH_BOT_CHAT: {
                    pushBotId = chatListItem.getId();
                }
            }
        }
        IntentUtils.setNextActivity((Context)this, ChatActivity2.class).putExtra("chatId", chatId).putExtra("pushBotId", pushBotId).setTransition(transition).startActivityForResult(21);
    }

    @Override
    public void receiveCommand(Command command, @Nullable Object object) {
        this.presenter.receiveCommand(command, object);
    }

    @Override
    public void receiveData(Entity entity, boolean upsert) {
        this.presenter.receiveData(entity, upsert);
        this.onUserChatsUpdate(this.adapter.getItemCount(), false);
    }

    @Override
    public void receiveStoreEvent(StoreType storeType, UpdateType updateType, @Nullable Entity entity) {
        if (StoreType.PLUGIN == storeType) {
            this.setFabTheme();
        }
        this.presenter.receiveStoreEvent(storeType, updateType, entity);
    }

    private void onUserChatsUpdate(int userChatCount, boolean hideContentLayout) {
        if (userChatCount < 2 && hideContentLayout) {
            this.contentLayout.setVisibility(8);
        } else {
            this.contentLayout.setVisibility(0);
            this.emptyLayout.setVisibility(UIUtils.getVisible(userChatCount <= 0, true));
            this.chatList.setVisibility(UIUtils.getVisible(userChatCount > 0, true));
        }
    }

    @Override
    @AnimRes
    protected int getExistAnimOfFinish() {
        return R.anim.ch_plugin_slide_out_bottom;
    }

    @Override
    public void onUserChatClick(@NonNull ChatListItem chatListItem) {
        this.startChat(chatListItem, false, true, false);
    }

    @Override
    public void onUserChatLongClick(@NonNull ChatListItem chatListItem) {
        this.showDeleteUserChatDialog(chatListItem);
    }
}

