package com.zoyi.channel.plugin.android.view.handler;

import android.graphics.PointF;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;

/**
 * Created by mika on 2016. 5. 25..
 */
public class BackgroundToucher implements View.OnTouchListener {
  private BaseActivity baseActivity;
  private EditText editText;
  @Nullable
  private PointF touchPoint = null;

  public static BackgroundToucher makeKeyboardEvent(
      BaseActivity baseActivity,
      RecyclerView recyclerView,
      EditText editText) {
    return new BackgroundToucher(baseActivity, recyclerView, editText);
  }

  private BackgroundToucher(
      BaseActivity baseActivity,
      RecyclerView recyclerView,
      EditText editText) {
    this.baseActivity = baseActivity;
    this.editText = editText;
    recyclerView.setOnTouchListener(this);
  }

  @Override
  public boolean onTouch(View v, MotionEvent event) {
    switch (event.getAction()) {
      case MotionEvent.ACTION_DOWN:
        touchPoint = new PointF(event.getX(), event.getY());
        break;
      case MotionEvent.ACTION_MOVE:
        break;
      case MotionEvent.ACTION_UP:
        if (touchPoint != null) {
          float x, y;
          x = event.getX();
          y = event.getY();

          if (Math.max(Math.abs(x - touchPoint.x), Math.abs(y - touchPoint.y)) < 10) {
            baseActivity.hideKeyboard(editText);
          }
        }
        touchPoint = null;
        break;
      case MotionEvent.ACTION_CANCEL:
        touchPoint = null;
        break;
    }
    return false;
  }
}