package com.zoyi.channel.plugin.android.activity.chat.view;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.utils.ChatResponseManager;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.CHHeaderView;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

/**
 * Created by mika on 2018. 11. 6..
 */

public class ChatHeaderView extends CHHeaderView {

  private Context context;

  private CHTextView textTitle;
  private CHTextView textDescription;
  private ImageView imageLeft;
  private ImageView imageRight;

  @Nullable
  private Channel channel;
  @Nullable
  private UserChat userChat;
  private boolean expand;

  public ChatHeaderView(@NonNull Context context) {
    super(context);
    init(context);
  }

  @Initializer
  public void init(Context context) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_chat_header, this, true);

    this.context = context;

    textTitle = view.findViewById(R.id.textChatHeaderTitle);
    textDescription = view.findViewById(R.id.textChatHeaderDescription);
    imageLeft = view.findViewById(R.id.imageChatHeaderLeftImage);
    imageRight = view.findViewById(R.id.imageChatHeaderRightImage);
  }

  public void bindChannel(@Nullable Channel channel) {
    this.channel = channel;
    setStyle(channel, userChat, expand);
  }

  public void bindUserChat(@Nullable UserChat userChat) {
    this.userChat = userChat;
    setStyle(channel, userChat, expand);
  }

  public void setExpand(boolean expand) {
    this.expand = expand;
    setStyle(channel, userChat, expand);
  }

  private void setStyle(@Nullable Channel channel, @Nullable UserChat userChat, boolean expand) {
    imageRight.setRotation(expand ? -180f : 0f);

    if (userChat == null || userChat.getHostType() == null || userChat.getHostId() == null) {
      imageLeft.setImageResource(ChatResponseManager.getResponseSymbol(channel));

      textTitle.setText(channel == null ? ResUtils.getString(context, "ch.unknown") : channel.getName());

      textDescription.setTextByKey(ChatResponseManager.getShortResponseDescriptionKey(channel));
      Views.setVisibility(textDescription, !expand);
    } else {
      ProfileEntity entity = ProfileSelector.getHostProfile(userChat.getHostType(), userChat.getHostId());

      imageLeft.setImageResource(ChatResponseManager.getManagerOnlineSymbol(entity));
      textTitle.setText(entity == null ? "" : entity.getName());
      textDescription.setVisibility(GONE);
    }

    Views.setVisibility(imageLeft, !expand, View.INVISIBLE);
  }

  @Override
  public void onTextColorChange(int textColor) {
    textTitle.setTextColor(textColor);
    textDescription.setTextColor(textColor);
    imageRight.setImageResource(
        textColor == Color.WHITE ? R.drawable.ch_plugin_dropdown_arrow_down : R.drawable.ch_plugin_dropdown_arrow_down_b
    );
  }
}
