package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;

/**
 * Created by mika on 2018. 10. 31..
 */

abstract class ConnectableMessageItem {
  public boolean isConnected(@Nullable MessageItem other) {
    if (other == null || !(other instanceof ConnectableMessageItem)) {
      return false;
    }

    ConnectableMessageItem otherItem = (ConnectableMessageItem) other;

    return isSamePerson(otherItem) &&
        CompareUtils.compare(
            TimeUtils.get(TimeUtils.MINUTE_24, getCreatedAt()),
            TimeUtils.get(TimeUtils.MINUTE_24, otherItem.getCreatedAt())
        ) == 0;
  }

  public abstract Long getCreatedAt();

  public abstract boolean isSamePerson(@NonNull ConnectableMessageItem item);
}
