/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.bumptech.glide.load.model.stream;

import android.content.Context;
import android.text.TextUtils;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.data.DataFetcher;
import com.zoyi.com.bumptech.glide.load.model.GlideUrl;
import com.zoyi.com.bumptech.glide.load.model.Headers;
import com.zoyi.com.bumptech.glide.load.model.ModelCache;
import com.zoyi.com.bumptech.glide.load.model.ModelLoader;
import com.zoyi.com.bumptech.glide.load.model.stream.StreamModelLoader;
import java.io.InputStream;

public abstract class BaseGlideUrlLoader<T>
implements StreamModelLoader<T> {
    private final ModelLoader<GlideUrl, InputStream> concreteLoader;
    private final ModelCache<T, GlideUrl> modelCache;

    public BaseGlideUrlLoader(Context context) {
        this(context, null);
    }

    public BaseGlideUrlLoader(Context context, ModelCache<T, GlideUrl> modelCache) {
        this(Glide.buildModelLoader(GlideUrl.class, InputStream.class, context), modelCache);
    }

    public BaseGlideUrlLoader(ModelLoader<GlideUrl, InputStream> concreteLoader) {
        this(concreteLoader, null);
    }

    public BaseGlideUrlLoader(ModelLoader<GlideUrl, InputStream> concreteLoader, ModelCache<T, GlideUrl> modelCache) {
        this.concreteLoader = concreteLoader;
        this.modelCache = modelCache;
    }

    @Override
    public DataFetcher<InputStream> getResourceFetcher(T model, int width, int height) {
        GlideUrl result = null;
        if (this.modelCache != null) {
            result = this.modelCache.get(model, width, height);
        }
        if (result == null) {
            String stringURL = this.getUrl(model, width, height);
            if (TextUtils.isEmpty((CharSequence)stringURL)) {
                return null;
            }
            result = new GlideUrl(stringURL, this.getHeaders(model, width, height));
            if (this.modelCache != null) {
                this.modelCache.put(model, width, height, result);
            }
        }
        return this.concreteLoader.getResourceFetcher(result, width, height);
    }

    protected abstract String getUrl(T var1, int var2, int var3);

    protected Headers getHeaders(T model, int width, int height) {
        return Headers.DEFAULT;
    }
}

