package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.L;

/**
 * Created by mika on 9/28/16.
 */
public class MenuButton extends RelativeLayout {

  int color = Color.WHITE;

  private MaskableFrameLayout mask;
  private FrameLayout colorLayout;
  private ImageView dummy;

  @Nullable
  private BigBar.MenuPosition menuPosition;
  @Nullable
  private ActionType action;
  @Nullable
  private Drawable iconId;


  public MenuButton(Context context) {
    super(context);
    init(context, null);
  }

  public MenuButton(Context context, AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public MenuButton(Context context, AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @TargetApi(Build.VERSION_CODES.LOLLIPOP)
  public MenuButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
    super(context, attrs, defStyleAttr, defStyleRes);
    init(context, attrs);
  }

  private void init(Context context, @Nullable AttributeSet attrs) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_menu_button, this);
    mask = (MaskableFrameLayout) findViewById(R.id.menu_icon_mask);
    colorLayout = (FrameLayout) findViewById(R.id.layout_color);
    dummy = (ImageView) findViewById(R.id.menu_icon_dummy);

    if (attrs != null) {
      TypedArray typedArray = context.getTheme().obtainStyledAttributes(
          attrs,
          R.styleable.MenuButton,
          0,
          0);

      try {
        color = typedArray.getColor(R.styleable.MenuButton_ch_back_color, color);
        iconId = typedArray.getDrawable(R.styleable.MenuButton_ch_image);
      } finally {
        typedArray.recycle();
      }
    }

    setIcon(iconId);
    setColor(color);
  }

  public void setIcon(@Nullable Drawable drawable) {
    if (drawable != null) {
      mask.setMask(drawable);
      dummy.setImageDrawable(drawable);
    }
  }

  public void setColor(@ColorInt int color) {
    colorLayout.setBackgroundColor(color);
  }

  public void setMenuPosition(@Nullable BigBar.MenuPosition menuPosition) {
    this.menuPosition = menuPosition;
  }

  @Nullable
  public BigBar.MenuPosition getMenuPosition() {
    return menuPosition;
  }

  public boolean isVisible() {
    return getVisibility() == VISIBLE;
  }

  public void setAction(ActionType action) {
    this.action = action;
    if (action != null && action.getIcon() != 0) {
      mask.setMask(action.getIcon());
      dummy.setImageResource(action.getIcon());
    }
  }

  @Nullable
  public ActionType getAction() {
    return action;
  }

  public enum ActionType {
    DONE(3),
    MORE(4),
    BACK(5),
    EXIT(6),
    CAMERA(7),
    REFRESH(8),
    DELETE(9),
    SETTINGS(10);

    private final int value;
    ActionType(int value) {
      this.value = value;
    }

    public int getIcon() {
      if (value == DONE.value) {
        return R.drawable.ch_plugin_ic_done_white_24dp;
      }
      if (value == MORE.value) {
        return R.drawable.ch_plugin_menu;
      }
      if (value == BACK.value) {
        return R.drawable.ch_plugin_chevron_left;
      }
      if (value == EXIT.value) {
        return R.drawable.ch_plugin_exit_white;
      }
      if (value == CAMERA.value) {
        return R.drawable.ch_plugin_ic_photo_camera_white_24dp;
      }
      if (value == REFRESH.value) {
        return R.drawable.ch_plugin_bar_refresh;
      }
      if (value == DELETE.value) {
        return R.drawable.ch_plugin_delete;
      }
      if (value == SETTINGS.value) {
        return R.drawable.ch_plugin_settings;
      }
      return 0;
    }
  }


  public enum MenuState {
    VISIBLE, DISABLED, HIDDEN
  }
}
