package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;

import com.zoyi.channel.plugin.android.activity.chat.type.ContentType;
import com.zoyi.channel.plugin.android.model.ActionInput;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Utils;

/**
 * Created by mika on 2016. 12. 22..
 */
public class SendingMessageItem extends ConnectableMessageItem implements MessageItem {

  @Nullable
  private String chatId;

  private String requestId;

  @Nullable
  private String text;
  @Nullable
  private String filePath;
  @Nullable
  private String actionType;
  @Nullable
  private ActionInput actionInput;

  private ContentType contentType;
  private boolean sending;

  private Long createdAt;

  @Nullable
  public static SendingMessageItem createDummy(@Nullable String requestId) {
    if (requestId == null) {
      return null;
    }
    SendingMessageItem item = new SendingMessageItem();
    item.requestId = requestId;
    try {
      item.createdAt = Long.parseLong(requestId.substring(0, 13));
    } catch (Exception ex) {
    }
    return item;
  }

  @NonNull
  public static SendingMessageItem copyContentFrom(@Nullable SendingMessageItem item) {
    if (item != null) {
      return new SendingMessageItem(item);
    }
    return new SendingMessageItem();
  }

  public SendingMessageItem() {
    this.createdAt = TimeUtils.getCurrentTime();
    this.requestId = "";
    this.contentType = ContentType.NONE;
  }

  public SendingMessageItem(@Nullable String chatId) {
    this.createdAt = TimeUtils.getCurrentTime();
    this.requestId = createdAt + Utils.getRandomString(4);
    this.chatId = chatId;
    this.sending = true;
    this.contentType = ContentType.NONE;
  }

  private SendingMessageItem(@NonNull SendingMessageItem item) {
    this.createdAt = TimeUtils.getCurrentTime();
    this.requestId = createdAt + Utils.getRandomString(4);

    this.chatId = item.getChatId();
    this.text = item.getText();
    this.filePath = item.getFilePath();
    this.actionInput = item.getActionInput();
    this.contentType = item.getContentType();

    this.sending = true;
  }

  @Override
  public Long getPrimaryKey() {
    return createdAt * 10;
  }

  @Override
  public String getSecondaryKey() {
    return requestId;
  }

  @NonNull
  public String getRequestId() {
    return requestId;
  }

  @Override
  public MessageType getType() {
    return MessageType.SENDING;
  }

  @Nullable
  public String getChatId() {
    return chatId;
  }

  public void setChatId(String chatId) {
    this.chatId = chatId;
  }

  public Long getCreatedAt() {
    return createdAt;
  }

  public ContentType getContentType() {
    return contentType;
  }

  // sending state getter/setter

  public boolean isSending() {
    return sending;
  }

  public void setSending(boolean sending) {
    this.sending = sending;
  }

  // Content getter/setter

  @Nullable
  public String getText() {
    return text;
  }

  public SendingMessageItem setText(@Nullable String text) {
    if (text != null) {
      this.text = text;
      this.contentType = ContentType.TEXT;
    }
    return this;
  }

  @Nullable
  public String getFilePath() {
    return filePath;
  }

  public SendingMessageItem setFilePath(@Nullable String filePath) {
    if (filePath != null) {
      this.filePath = filePath;
      this.contentType = ContentType.FILE;
    }
    return this;
  }

  @Nullable
  public String getActionType() {
    return actionType;
  }

  @Nullable
  public ActionInput getActionInput() {
    return actionInput;
  }

  public SendingMessageItem setActionInput(@Nullable String actionType, @Nullable ActionInput actionInput) {
    if (actionType != null && actionInput != null) {
      this.actionType = actionType;
      this.actionInput = actionInput;
      this.contentType = ContentType.FORM;
    }
    return this;
  }

  // 서포트 봇으로 유저챗 생성 시에 실제 메시지를 설정해주는 함수
  public void updateMessageOnActionInput(@NonNull Message message) {
    if (contentType == ContentType.FORM && actionInput != null) {
      actionInput.setMessage(message);
    }
  }

  // etc getters

  @Override
  public boolean isSamePerson(@NonNull ConnectableMessageItem item) {
    if (item instanceof SendingMessageItem) {
      return true;
    }
    else if (item instanceof ChatMessageItem) {
      return ((ChatMessageItem) item).getType() == MessageType.GUEST;
    }
    return false;
  }
}
