/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelApiManager;
import com.zoyi.channel.plugin.android.activity.userchat_list.contract.UserChatAdapterContract;
import com.zoyi.channel.plugin.android.activity.userchat_list.contract.UserChatListContract;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.ChatListItem;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.enumerate.UserChatListState;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.wrapper.ChatPreloadWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ManagersWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.SupportBotEntry;
import com.zoyi.channel.plugin.android.model.wrapper.SupportBotsWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.selector.PushBotSelector;
import com.zoyi.channel.plugin.android.selector.UiStateSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store.PushBotItemStore;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.store.SupportBotStore;
import com.zoyi.channel.plugin.android.store.UserChatStore;
import com.zoyi.channel.plugin.android.util.ConditionUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.functions.Func2;
import com.zoyi.rx.functions.Func3;
import com.zoyi.rx.schedulers.Schedulers;

public class UserChatListPresenter
implements UserChatListContract.Presenter {
    private UserChatListContract.View view;
    private UserChatAdapterContract.View adapterView;
    private UserChatAdapterContract.Model adapterModel;
    private Context context;
    private UserChatListState state = UserChatListState.WAITING_SOCKET;
    private boolean init = true;
    private boolean chatLoading = false;

    public UserChatListPresenter(Context context) {
        this.context = context;
    }

    @Override
    @Initializer
    public void setView(UserChatListContract.View view) {
        this.view = view;
    }

    @Override
    @Initializer
    public void setAdapterView(UserChatAdapterContract.View adapterView) {
        this.adapterView = adapterView;
    }

    @Override
    @Initializer
    public void setAdapterModel(UserChatAdapterContract.Model adapterModel) {
        this.adapterModel = adapterModel;
    }

    @Override
    public void refresh() {
        switch (this.state) {
            case WAITING_SOCKET: {
                if (SocketManager.isReady()) {
                    this.getUserChats();
                    break;
                }
                SocketManager.connect();
                break;
            }
            case READY: 
            case USER_CHAT_LIST_NOT_LOADED: {
                this.getUserChats();
            }
        }
    }

    @Override
    public void redrawList() {
        this.adapterView.notifyDataSetChanged();
    }

    private void setState(UserChatListState state) {
        this.state = state;
    }

    private boolean canUpdate() {
        return UserChatListState.READY.equals((Object)this.state);
    }

    private void getUserChats() {
        this.view.setErrorView(false);
        if (SocketManager.isReady()) {
            this.view.showProgress(ResUtils.getString(this.context, "ch.loading_information"));
            this.setState(UserChatListState.USER_CHAT_LIST_LOADING);
            this.fetchUserChats();
        } else {
            this.setState(UserChatListState.WAITING_SOCKET);
            SocketManager.reconnect();
        }
    }

    @Override
    public void receiveCommand(Command command, @Nullable Object object) {
        switch (command) {
            case READY: {
                this.view.setErrorView(false);
                if (UserChatListState.WAITING_SOCKET.equals((Object)this.state)) {
                    this.getUserChats();
                    break;
                }
                this.refresh();
                break;
            }
            case SOCKET_DISCONNECTED: {
                boolean force;
                this.setState(UserChatListState.WAITING_SOCKET);
                Store.getInstance(UserChatStore.class).setCanUpdate(false);
                if (object == null || !(object instanceof Boolean) || (force = ((Boolean)object).booleanValue())) break;
                this.view.setErrorView(true);
                break;
            }
            case SOCKET_ERROR: {
                this.setState(UserChatListState.WAITING_SOCKET);
                Store.getInstance(UserChatStore.class).setCanUpdate(false);
                this.view.setErrorView(true);
            }
        }
    }

    @Override
    public void receiveData(Entity entity, boolean upsert) {
        if (entity != null && this.canUpdate()) {
            if (entity instanceof Session) {
                this.adapterModel.updateSession((Session)entity);
            } else if (entity instanceof Manager) {
                this.adapterModel.updateManager(entity.getId());
            }
        }
    }

    @Override
    public void receiveStoreEvent(StoreType storeType, UpdateType updateType, @Nullable Entity entity) {
        if (entity != null && this.canUpdate()) {
            switch (storeType) {
                case USER_CHAT: {
                    UserChat userChat = (UserChat)entity;
                    switch (updateType) {
                        case DELETE: {
                            this.adapterModel.removeUserChat(userChat.getId());
                            break;
                        }
                        case UPDATE: {
                            this.adapterModel.upsertUserChat(userChat);
                        }
                    }
                    break;
                }
                case PUSH_BOT_ITEM: {
                    PushBotItem pushBotItem = (PushBotItem)entity;
                    if (updateType != UpdateType.UPDATE) break;
                    if (pushBotItem.shouldShowToList()) {
                        this.adapterModel.upsertPushBotItem(pushBotItem);
                        break;
                    }
                    this.adapterModel.removePushBotItem(pushBotItem);
                }
            }
        }
    }

    private void fetchUserChats() {
        ChannelApiManager.get().getUserChats("updatedAt", "DESC", 50, UiStateSelector.shouldShowClosedChat()).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<UserChatsWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                UserChatListPresenter.this.init = false;
                UserChatListPresenter.this.view.hideProgress();
                UserChatListPresenter.this.handleError();
            }

            @Override
            public void onNext(UserChatsWrapper repo) {
                UserChatListPresenter.this.view.hideProgress();
                if (repo != null) {
                    repo.set();
                    UserChatListPresenter.this.setState(UserChatListState.READY);
                    UserChatListPresenter.this.adapterModel.setUserChats(repo.getUserChats());
                    UserChatListPresenter.this.view.userChatsFetched(UserChatListPresenter.this.init);
                    UserChatListPresenter.this.init = false;
                } else {
                    UserChatListPresenter.this.handleError();
                }
            }
        });
    }

    public void handleError() {
        if (UserChatListState.USER_CHAT_LIST_LOADING.equals((Object)this.state)) {
            this.setState(UserChatListState.USER_CHAT_LIST_NOT_LOADED);
            this.view.setErrorView(true);
        }
    }

    @Override
    public void removeUserChat(final @NonNull String chatId) {
        this.view.showProgress(ResUtils.getString(this.context, "ch.chat.delete_progress"));
        ChannelApiManager.get().removeUserChat(chatId).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<Void>(){

            @Override
            public void onError(RetrofitException error) {
            }

            @Override
            public void onNext(Void aVoid) {
                UserChat userChat = (UserChat)Store.getInstance(UserChatStore.class).get(chatId);
                if (userChat != null) {
                    userChat.setState("removed");
                    Store.getInstance(UserChatStore.class).add(userChat);
                }
                UserChatListPresenter.this.adapterModel.removeUserChat(chatId);
                UserChatListPresenter.this.view.completeRemoveChat();
            }
        });
    }

    @Override
    public void removePushBotChat(@NonNull String pushBotId) {
        PushBotItem pushBotItem = PushBotSelector.get(pushBotId);
        if (pushBotItem != null) {
            pushBotItem.remove();
            Store.getInstance(PushBotItemStore.class).add(pushBotItem);
            this.adapterModel.removePushBotItem(pushBotItem);
            this.view.completeRemoveChat();
        }
    }

    @Override
    public void fetchPreloadData(final @Nullable ChatListItem chatListItem, final Transition transition) {
        Plugin plugin = PluginSelector.getPlugin();
        if (plugin == null) {
            return;
        }
        if (this.chatLoading) {
            return;
        }
        this.chatLoading = true;
        Observable.zip(ChannelApiManager.get().getFollowingManagers(), ChannelApiManager.get().getPlugin(plugin.getId()), ChannelApiManager.get().getSupportBots(plugin.getId()), (Func3)new Func3<ManagersWrapper, PluginWrapper, SupportBotsWrapper, ChatPreloadWrapper>(){

            public ChatPreloadWrapper call(ManagersWrapper managersWrapper, PluginWrapper pluginWrapper, SupportBotsWrapper supportBotsWrapper) {
                return new ChatPreloadWrapper(managersWrapper, pluginWrapper, supportBotsWrapper);
            }
        }).flatMap((Func1)new Func1<ChatPreloadWrapper, Observable<ChatPreloadWrapper>>(){

            public Observable<ChatPreloadWrapper> call(ChatPreloadWrapper chatPreloadWrapper) {
                String validSupportBotId = ConditionUtils.getFirstValidSupportBotId(chatPreloadWrapper.getSupportBotsWrapper());
                if (validSupportBotId != null) {
                    return Observable.zip((Observable)Observable.just((Object)chatPreloadWrapper), ChannelApiManager.get().getSupportBotEntry(validSupportBotId), (Func2)new Func2<ChatPreloadWrapper, SupportBotEntry, ChatPreloadWrapper>(){

                        public ChatPreloadWrapper call(ChatPreloadWrapper chatPreloadWrapper, SupportBotEntry supportBotEntry) {
                            return chatPreloadWrapper.updateSupportBotEntry(supportBotEntry);
                        }
                    });
                }
                return Observable.just((Object)chatPreloadWrapper);
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<ChatPreloadWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                L.e(error.getMessage());
                UserChatListPresenter.this.chatLoading = false;
            }

            @Override
            public void onNext(ChatPreloadWrapper repo) {
                if (repo != null) {
                    repo.update();
                    Store.getInstance(SupportBotStore.class).setSupportBotEntry(repo.getSupportBotEntry());
                    UserChatListPresenter.this.view.successFetchPreloadData(chatListItem, transition);
                }
                UserChatListPresenter.this.chatLoading = false;
            }
        });
    }

    @Override
    @Nullable
    public ChatListItem getUserChatItem(@NonNull String id2) {
        return this.adapterModel.getUserChatItem(id2);
    }
}

