package com.zoyi.channel.plugin.android.activity.chat.view;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.type.ChatNavigationState;
import com.zoyi.channel.plugin.android.activity.chat.utils.ChatResponseManager;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.Person;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.selector.ManagerSelector;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

import java.util.List;

/**
 * Created by mika on 2018. 10. 23..
 */

public class ChatNavigationView extends LinearLayout {

  private View layoutRoot;

  private View layoutPending;
  private CHTextView textPendingTitle;
  private CHTextView textPendingDescription;
  private View layoutPendingAvatars;
  private AvatarLayout avatarPendingFirst;
  private AvatarLayout avatarPendingSecond;
  private AvatarLayout avatarPendingThird;
  private CHTextView textPendingWorkingTime;

  private View layoutFollowing;
  private View layoutFollowingAvatarFrame;
  private AvatarLayout avatarFollowing;
  private View viewFollowingManagerOnlineBadge;
  private View viewFollowingManagerOnlineBadgeFrame;
  private CHTextView textFollowingManagerDescription;

  private ChatNavigationState state = ChatNavigationState.IDLE;

  public ChatNavigationView(Context context) {
    super(context);
    init(context);
  }

  public ChatNavigationView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public ChatNavigationView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  private void init(Context context) {
    // Layout inflate
    layoutRoot = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_chat_navigation, this);

    layoutPending = layoutRoot.findViewById(R.id.layout_chat_navigation_pending);
    textPendingTitle = (CHTextView) layoutRoot.findViewById(R.id.text_chat_navigation_pending_title);
    textPendingDescription = (CHTextView) layoutRoot.findViewById(R.id.text_chat_navigation_pending_description);
    layoutPendingAvatars = layoutRoot.findViewById(R.id.layout_chat_navigation_pending_avatars);
    avatarPendingFirst = (AvatarLayout) layoutRoot.findViewById(R.id.avatar_chat_navigation_pending_first);
    avatarPendingSecond = (AvatarLayout) layoutRoot.findViewById(R.id.avatar_chat_navigation_pending_second);
    avatarPendingThird = (AvatarLayout) layoutRoot.findViewById(R.id.avatar_chat_navigation_pending_third);
    textPendingWorkingTime = layoutRoot.findViewById(R.id.text_chat_navigation_working_time);

    layoutFollowing = layoutRoot.findViewById(R.id.layout_chat_navigation_following);
    layoutFollowingAvatarFrame = layoutRoot.findViewById(R.id.view_chat_navigation_following_manager_frame);
    avatarFollowing = (AvatarLayout) layoutRoot.findViewById(R.id.avatar_chat_navigation_following);
    viewFollowingManagerOnlineBadge = layoutRoot.findViewById(R.id.badge_chat_navigation_following_manager_online);
    viewFollowingManagerOnlineBadgeFrame = layoutRoot.findViewById(R.id.view_chat_navigation_following_manager_online_frame);
    textFollowingManagerDescription = layoutRoot.findViewById(R.id.text_chat_navigation_following_manager_description);

    // Layout styling
    layoutRoot.setBackgroundColor(ColorSelector.getBackgroundColor());

    avatarPendingFirst.setBorderColor(ColorSelector.getBackgroundColor());
    avatarPendingSecond.setBorderColor(ColorSelector.getBackgroundColor());
    avatarPendingThird.setBorderColor(ColorSelector.getBackgroundColor());

    avatarFollowing.setBorderColor(ColorSelector.getBackgroundColor());
    viewFollowingManagerOnlineBadgeFrame.setBackgroundColor(ColorSelector.getBackgroundColor());

    textPendingTitle.setTextColor(ColorSelector.getTextColor());
    textPendingDescription.setTextColor(ColorSelector.getTextColor());
    textPendingWorkingTime.setTextColor(ColorSelector.getTextColor());
    textFollowingManagerDescription.setTextColor(ColorSelector.getTextColor());

    // Layout visibility
    layoutRoot.setVisibility(View.GONE);
    layoutPending.setVisibility(View.GONE);
    layoutFollowing.setVisibility(View.GONE);

    bindFollowingManagers(ManagerSelector.getFollowingManagers());
    bindChannel(ChannelSelector.getCurrentChannel());
  }

  public void bindFollowingManagers(@Nullable List<Manager> followingManagers) {
    if (followingManagers != null) {
      layoutPendingAvatars.setVisibility(View.VISIBLE);

      avatarPendingFirst.set(followingManagers.size() > 0 ? followingManagers.get(0) : null);
      avatarPendingSecond.set(followingManagers.size() > 1 ? followingManagers.get(1) : null);
      avatarPendingThird.set(followingManagers.size() > 2 ? followingManagers.get(2) : null);
    }
  }

  public void bindChannel(@Nullable Channel channel) {
    if (channel != null) {
      layoutRoot.setVisibility(View.VISIBLE);
    }

    // descriptions
    textPendingTitle.setTextByKey(ChatResponseManager.getResponseKey(channel));
    textPendingTitle.setCompoundDrawablesWithIntrinsicBounds(0, 0, ChatResponseManager.getResponseSymbol(channel), 0);
    textPendingDescription.setTextByKey(ChatResponseManager.getResponseDescriptionKey(channel));

    // avatar
    int maxAvatarCount = ChatResponseManager.showOnlyOneManager(channel) ? 1 : 3;
    Views.setVisibility(avatarPendingFirst, avatarPendingFirst.isValid());
    Views.setVisibility(avatarPendingSecond, avatarPendingSecond.isValid() && maxAvatarCount >= 2);
    Views.setVisibility(avatarPendingThird, avatarPendingThird.isValid() && maxAvatarCount >= 3);

    // Working time
    boolean workingTimeNotExists = channel == null
        || channel.isWorking()
        || Const.WORKING_TYPE_NEVER.equals(channel.getWorkingType())
        || channel.getWorkingTime(getContext()) == null;

    Views.setVisibility(textPendingWorkingTime, !workingTimeNotExists);
  }

  public boolean bindUserChat(@Nullable UserChat userChat) {
    ChatNavigationState oldState = this.state;

    Person followingPerson = ProfileSelector.getPerson(
        userChat != null ? userChat.getHostType() : null,
        userChat != null ? userChat.getHostId() : null
    );

    state = followingPerson != null
        ? ChatNavigationState.FOLLOWING
        : ChatResponseManager.getNavigationState(ChannelSelector.getCurrentChannel());

    Views.setVisibility(layoutPending, state != ChatNavigationState.FOLLOWING);
    Views.setVisibility(layoutFollowing, state == ChatNavigationState.FOLLOWING);

    if (state == ChatNavigationState.FOLLOWING) {
      avatarFollowing.set(followingPerson);

      if (followingPerson != null && followingPerson instanceof Manager) {
        Manager followingManager = (Manager) followingPerson;

        Views.setVisibility(viewFollowingManagerOnlineBadge, followingManager.getOnline());
        Views.setVisibility(textFollowingManagerDescription, false);    // Manager description validation
      } else {
        viewFollowingManagerOnlineBadge.setVisibility(View.GONE);
        textFollowingManagerDescription.setVisibility(View.GONE);
      }

      if (state != oldState) {
        animateScaleUpView(layoutFollowingAvatarFrame, 0);
      }
    } else if (state != oldState) {
      animateScaleUpView(avatarPendingFirst, 0);
      animateScaleUpView(avatarPendingSecond, 1);
      animateScaleUpView(avatarPendingThird, 2);
    }

    return state == ChatNavigationState.FOLLOWING;
  }

  private void animateScaleUpView(final View view, int index) {
    view.setScaleX(0.3f);
    view.setScaleY(0.3f);

    new Handler().postDelayed(new Runnable() {
      @Override
      public void run() {
        view.animate().scaleX(1.0f).scaleY(1.0f).start();
      }
    }, index + 50 + 200);
  }
}
