package com.zoyi.channel.plugin.android.selector;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.Veil;
import com.zoyi.channel.plugin.android.store.SessionStore;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.store.UserStore;
import com.zoyi.channel.plugin.android.store.VeilStore;

/**
 * Created by mika on 2018. 6. 19..
 */

public class CounterSelector extends BaseSelector {

  @NonNull
  public static String getChatCounter(@Nullable String userChatId) {
    Session session = Store.getInstance(SessionStore.class).get(userChatId);

    if (session == null || session.getAlert() == null || session.getAlert() <= 0) {
      return "";
    } else if (session.getAlert() > 99) {
      return "99+";
    }
    return String.valueOf(session.getAlert());
  }

  public static int getTotalCounter() {
    int totalVisiblePushBotCount = PushBotSelector.getTotalVisiblePushBotCount();

    User user = Store.getInstance(UserStore.class).get();
    Veil veil = Store.getInstance(VeilStore.class).get();

    if (user != null) {
      return user.getAlert() + totalVisiblePushBotCount;
    } else if (veil != null) {
      return veil.getAlert() + totalVisiblePushBotCount;
    } else {
      return totalVisiblePushBotCount;
    }
  }
}
