package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnChangeInputStateListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileBotUpdateListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileEventListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileUpdateListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.activity.chat.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.view.MobileNumberProfileMessageView;
import com.zoyi.channel.plugin.android.activity.chat.view.ProfileMessageView;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.ProfileBot;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.GuestSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by mika on 2018. 4. 17..
 */

public class ProfileBotMessageHolder
    extends RecyclerView.ViewHolder
    implements OnProfileEventListener,
    OnChangeInputStateListener {

  private Context context;
  @Nullable
  private OnProfileUpdateListener onProfileUpdateListener;
  @Nullable
  private OnProfileBotUpdateListener onProfileBotUpdateListener;

  private LinearLayout profileItems;
  private CHTextView terms;

  private boolean init = false;
  private boolean hasFocus = false;
  @Nullable
  private Map<String, ProfileMessageView> profileInputViewMap;
  @Nullable
  private ProfileBotMessageItem item;

  public static ProfileBotMessageHolder newInstance(ViewGroup parent, @Nullable OnProfileUpdateListener listener) {
    LayoutInflater inflater = LayoutInflater.from(parent.getContext());
    return new ProfileBotMessageHolder(
        inflater.inflate(R.layout.ch_plugin_item_message_profile, parent, false),
        listener);
  }

  public static ProfileBotMessageHolder newInstance(ViewGroup parent, @Nullable OnProfileBotUpdateListener listener) {
    LayoutInflater inflater = LayoutInflater.from(parent.getContext());
    return new ProfileBotMessageHolder(
        inflater.inflate(R.layout.ch_plugin_item_message_profile, parent, false),
        listener);
  }

  private ProfileBotMessageHolder(View itemView) {
    super(itemView);
    this.context = itemView.getContext();

    this.profileItems = (LinearLayout) itemView.findViewById(R.id.ch_layout_message_profile_items);
    this.terms = itemView.findViewById(R.id.ch_view_message_profile_terms);
  }

  private ProfileBotMessageHolder(View itemView, @Nullable OnProfileUpdateListener onProfileUpdateListener) {
    this(itemView);
    this.onProfileUpdateListener = onProfileUpdateListener;
  }

  private ProfileBotMessageHolder(View itemView, @Nullable OnProfileBotUpdateListener onProfileBotUpdateListener) {
    this(itemView);
    this.onProfileBotUpdateListener = onProfileBotUpdateListener;
  }

  private void initView(Message message) {
    init = true;
    profileInputViewMap = new HashMap<>();

    if (message != null && message.getProfileBot() != null) {
      List<ProfileBot> profileBots = message.getProfileBot();

      for (ProfileBot profileBot : profileBots) {
        ProfileMessageView profileMessageView;

        if ("mobileNumber".equals(profileBot.getKey())) {
          profileMessageView = new MobileNumberProfileMessageView(context, this, this);
        } else {
          profileMessageView = new ProfileMessageView(context, this, this);
        }

        profileMessageView.setKey(profileBot.getKey());
        profileMessageView.setType(profileBot.getType());

        profileInputViewMap.put(profileBot.getKey(), profileMessageView);
        profileItems.addView(profileMessageView);
      }
    }

    setTerms(PrefSupervisor.getPluginLanguage(context));
  }


  public void bind(ProfileBotMessageItem item, boolean hasMessageEditTextFocus) {
    this.item = item;
    Message message = item.getMessage();

    if (!init) {
      initView(message);
    }

    if (message != null && message.getProfileBot() != null) {
      List<ProfileBot> profileBots = message.getProfileBot();

      boolean inputActivated = false;
      int activatedIndex = profileBots.size();

      for (int index = 0; index < profileBots.size(); index++) {
        ProfileBot profileBot = profileBots.get(index);
        String profileKey = profileBot.getKey();

        if (profileInputViewMap != null && profileInputViewMap.containsKey(profileKey)) {
          ProfileMessageView profileMessageView = profileInputViewMap.get(profileKey);

          if (inputActivated) {
            profileMessageView.setVisibility(View.GONE);
            continue;
          }

          Object inputState = null;
          String error = null;
          boolean isLoading = false;

          if (CompareUtils.isSame(item.getInputKey(), profileKey)) {
            error = item.getInputError();
            inputState = item.getInputState();
            isLoading = item.isInputLoading();
          }

          // 현재 위치가 열려있다
          if (profileBot.getValue() == null || TextUtils.isEmpty(profileBot.getValue().toString())) {
            inputActivated = true;
            activatedIndex = index;

            if (!CompareUtils.isSame(item.getInputKey(), profileKey)) {
              Guest guest = GuestSelector.get();

              if (guest != null && guest.getProfileValue(profileKey) != null && !item.isLastProfileTyping()) {
                if ("mobileNumber".equals(profileKey)) {
                  inputState = new MobileNumber((String) guest.getProfileValue(profileKey));
                } else {
                  inputState = guest.getProfileValue(profileKey);
                }
              }
            }
          }

          profileMessageView.setVisibility(View.VISIBLE);
          profileMessageView.setState(
              profileBot.getName(),
              error,
              index + 1,
              profileBots.size(),
              profileBot.getValue(),
              inputState,
              isLoading,
              hasFocus || (!hasMessageEditTextFocus && item.isLastProfileTyping()),
              index == profileBots.size() - 1);
        }
      }

      if (activatedIndex > 0) {
        terms.setVisibility(View.GONE);
      }

      // 완료
      if (activatedIndex == profileBots.size() && onProfileUpdateListener != null) {
        onProfileUpdateListener.onCompleteWriteProfile();
      }
      if (activatedIndex == profileBots.size() && onProfileBotUpdateListener != null) {
        onProfileBotUpdateListener.onProfileBotUpdateComplete();
      }
    }
  }

  private void setTerms(String lang) {
    terms.setText(Utils.getHtmlFormattedText(ResUtils.getString(context, "ch.agreement")));

    final String url;
    String pluginKey = PluginSelector.getPluginKey();
    
    if (pluginKey != null) {
      url = String.format("https://channel.io/%s/terms_user?plugin_key=%s", lang, pluginKey);
    } else {
      url = String.format("https://channel.io/%s/terms_user", lang);
    }

    terms.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        IntentUtils.setUrl(context, url).startActivity();
      }
    });
  }

  @Override
  public void onCountryCodeClick(@Nullable String key, MobileNumber mobileNumber) {
    if (onProfileUpdateListener != null && item != null && key != null) {
      onProfileUpdateListener.getCountries(item, key, mobileNumber);
    }
    if (onProfileBotUpdateListener != null && item != null && key != null) {
      onProfileBotUpdateListener.onCountrySelectorClick(item, key, mobileNumber);
    }
  }

  @Override
  public void onSendButtonClick(@Nullable String key, Object value, Object inputState) {
    if (item != null && onProfileUpdateListener != null && key != null) {
      hasFocus = true;
      item.setInputState(inputState);
      onProfileUpdateListener.onProfileUpdate(item, key, value);
    }
    if (item != null && onProfileBotUpdateListener != null && key != null) {
      hasFocus = true;
      item.setInputState(inputState);
      onProfileBotUpdateListener.onProfileBotUpdateButtonClick(item, key, value);
    }
  }

  @Override
  public void onChangeFocus(boolean hasFocus) {
    this.hasFocus = hasFocus;
    if (onProfileUpdateListener != null) {
      onProfileUpdateListener.onChangeProfileFocus(hasFocus);
    }
    if (onProfileBotUpdateListener != null) {
      onProfileBotUpdateListener.onProfileBotFocusChange(hasFocus);
    }
  }

  @Override
  public void onUpdateInputState(@Nullable String key, Object inputState, boolean isTyping) {
    if (item != null) {
      item.setLastProfileTypingState(isTyping);
      item.setInputState(key, inputState, false, null);
    }
  }
}
