/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageButton;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapter2;
import com.zoyi.channel.plugin.android.activity.chat.ChatContract2;
import com.zoyi.channel.plugin.android.activity.chat.ChatPresenter2;
import com.zoyi.channel.plugin.android.activity.chat.TypingManager;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnNewMessageAlertClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileBotUpdateListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.activity.chat.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.view.ChatHeaderView;
import com.zoyi.channel.plugin.android.activity.chat.view.ChatNavigationView;
import com.zoyi.channel.plugin.android.activity.chat.view.NewMessageAlertView;
import com.zoyi.channel.plugin.android.activity.chat.view.overlayheader.OnHeaderStateChangeListener;
import com.zoyi.channel.plugin.android.activity.chat.view.overlayheader.OverlayHeaderCallback;
import com.zoyi.channel.plugin.android.activity.chat.view.overlayheader.OverlayHeaderRecyclerView;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumStorage;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerActivity;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.activity.video.VideoViewerActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.ActionInput;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.CounterSelector;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.selector.UserChatSelector;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.util.message_format.type.LinkType;
import com.zoyi.channel.plugin.android.view.dialog.CountryCodeDialog;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.BottomFloatingActionLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import com.zoyi.channel.plugin.android.view.layout.NewChatButton;
import com.zoyi.channel.plugin.android.view.layout.PushBotSaveButton;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import java.util.concurrent.TimeUnit;

public class ChatActivity2
extends BaseActivity
implements ChatContract2.View,
OnNewMessageAlertClickListener,
EditTextChangedListener,
OverlayHeaderCallback,
OnHeaderStateChangeListener,
OnProfileBotUpdateListener,
OnMessageContentClickListener {
    private OverlayHeaderRecyclerView overlayHeaderRecyclerView;
    private WatchedEditText editChat;
    private ImageButton buttonSend;
    private View layoutInput;
    private View layoutInputFrame;
    private NewMessageAlertView viewNewMessageAlert;
    private CHTextView textDisabled;
    private BottomFloatingActionLayout viewBottomFloating;
    private NewChatButton buttonNewChat;
    private PushBotSaveButton pushBotSaveButton;
    private View buttonPhotoPicker;
    @NonNull
    private ChatNavigationView chatNavigation;
    @NonNull
    private ChatHeaderView chatHeaderView;
    private LinearLayoutManager layoutManager;
    private ChatContract2.Presenter presenter;
    private ChatAdapter2 adapter;
    @Nullable
    private Subscription countSubscription;
    private int exitAnimation = R.anim.ch_plugin_slide_out_right;

    @Override
    @Initializer
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_chat);
        String chatId = this.getIntent() != null ? this.getIntent().getStringExtra("chatId") : null;
        String pushBotId = this.getIntent() != null ? this.getIntent().getStringExtra("pushBotId") : null;
        this.viewNewMessageAlert = (NewMessageAlertView)this.findViewById(R.id.view_new_message_alert);
        this.buttonPhotoPicker = this.findViewById(R.id.button_attach);
        this.buttonSend = (ImageButton)this.findViewById(R.id.iv_chat_send);
        this.textDisabled = (CHTextView)this.findViewById(R.id.text_disabled_input);
        this.layoutInputFrame = this.findViewById(R.id.layout_bottom);
        this.layoutInput = this.findViewById(R.id.layout_input);
        this.viewBottomFloating = (BottomFloatingActionLayout)this.findViewById(R.id.ch_layout_bottom_floating_action);
        this.buttonNewChat = (NewChatButton)this.findViewById(R.id.ch_button_new_chat);
        this.pushBotSaveButton = (PushBotSaveButton)this.findViewById(R.id.ch_button_push_bot_save);
        this.overlayHeaderRecyclerView = (OverlayHeaderRecyclerView)this.findViewById(R.id.recycler_header);
        this.editChat = (WatchedEditText)this.findViewById(R.id.edit_chat);
        this.adapter = new ChatAdapter2();
        this.adapter.setOnMessageContentClickListener(this);
        this.adapter.setOnProfileBotUpdateListener(this);
        this.presenter = new ChatPresenter2(chatId, pushBotId, new TypingManager(this.editChat));
        this.presenter.setView(this);
        this.presenter.setAdapterModel(this.adapter);
        this.presenter.setAdapterView(this.adapter);
        this.chatNavigation = new ChatNavigationView((Context)this);
        this.chatHeaderView = new ChatHeaderView((Context)this);
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.layoutManager.setStackFromEnd(true);
        this.viewNewMessageAlert.setListener(this);
        this.editChat.setWatchedTextChangedListener(this);
        this.editChat.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                ChatActivity2.this.adapter.setEditTextFocused(hasFocus);
            }
        });
        this.editChat.setText(PrefSupervisor.getStoredMessage((Context)this));
        PrefSupervisor.clearStoredMessage((Context)this);
        this.buttonPhotoPicker.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatActivity2.this.hideKeyboard((EditText)ChatActivity2.this.editChat);
                IntentUtils.setNextActivity((Context)ChatActivity2.this, PhotoPickerActivity.class).startActivityForResult(902);
            }
        });
        this.buttonSend.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatActivity2.this.presenter.sendText(StringUtils.stripEnd(ChatActivity2.this.editChat.getString(), null));
                ChatActivity2.this.editChat.setText("");
            }
        });
        this.buttonNewChat.setClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatActivity2.this.setResult(22);
                ChatActivity2.this.finish();
            }
        });
        this.pushBotSaveButton.setClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatActivity2.this.setPushBotSaveButtonVisibility(false);
                ChatActivity2.this.presenter.createPushBotUserChat();
            }
        });
        this.overlayHeaderRecyclerView.getRecyclerView().setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.overlayHeaderRecyclerView.getRecyclerView().setAdapter((RecyclerView.Adapter)this.adapter);
        this.overlayHeaderRecyclerView.getRecyclerView().setItemAnimator(null);
        this.overlayHeaderRecyclerView.addBannerView((View)this.chatNavigation);
        this.overlayHeaderRecyclerView.setCallback(this);
        this.overlayHeaderRecyclerView.setListener(this);
        this.overlayHeaderRecyclerView.getRecyclerView().addOnScrollListener((RecyclerView.OnScrollListener)new InfiniteScrollListener(this.layoutManager, 1, this.overlayHeaderRecyclerView.getRecyclerView()){

            @Override
            public void scrolledInList() {
                ChatActivity2.this.viewBottomFloating.hide();
            }

            @Override
            public void scrollAttachedToBottom() {
                ChatActivity2.this.viewNewMessageAlert.hide();
                ChatActivity2.this.viewBottomFloating.show();
            }

            @Override
            public void refresh() {
                ChatActivity2.this.presenter.fetchBackwardMessages();
            }
        });
        this.viewBottomFloating.setRecyclerView(this.overlayHeaderRecyclerView.getRecyclerView());
        this.chatHeaderView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatActivity2.this.overlayHeaderRecyclerView.toggleBanner();
            }
        });
        this.chatHeaderView.bindChannel(ChannelSelector.getCurrentChannel());
        this.getBigBar().withActivity(this).addMenu(MenuButton.ActionType.SETTINGS, BigBar.MenuPosition.LEFT, MenuButton.MenuState.HIDDEN).addMenu(MenuButton.ActionType.BACK, BigBar.MenuPosition.LEFT, MenuButton.MenuState.HIDDEN).addText(BigBar.MenuPosition.LEFT).addMenu(MenuButton.ActionType.REFRESH, BigBar.MenuPosition.RIGHT, MenuButton.MenuState.HIDDEN).addMenu(MenuButton.ActionType.EXIT, BigBar.MenuPosition.RIGHT).setHeaderView(this.chatHeaderView).build();
        this.setInputFrameVisibility(false);
        this.setInputState(ChannelSelector.getCurrentChannel(), true);
        this.refreshChatCount(true);
        this.refreshMenu(chatId == null);
        this.bindChannel(ChannelSelector.getCurrentChannel());
        this.presenter.init();
    }

    @Override
    protected void onDestroy() {
        this.presenter.release();
        if (this.countSubscription != null && !this.countSubscription.isUnsubscribed()) {
            this.countSubscription.unsubscribe();
        }
        super.onDestroy();
    }

    @Override
    public void optionClicked(MenuButton.ActionType actionType) {
        switch (actionType) {
            case REFRESH: {
                this.presenter.refresh();
                break;
            }
            case SETTINGS: {
                IntentUtils.setNextActivity((Context)this, SettingsActivity.class).setTransition(Transition.SLIDE_FROM_BOTTOM).startActivityForResult(3002);
                break;
            }
            case BACK: {
                this.onBackPressed();
                break;
            }
            case EXIT: {
                this.exitMessenger();
            }
        }
    }

    public void onBackPressed() {
        if (UserChatSelector.isEmpty() && this.presenter.isLocalChat()) {
            this.exitMessenger();
        } else {
            super.onBackPressed();
        }
    }

    private void exitMessenger() {
        this.exitAnimation = R.anim.ch_plugin_slide_out_bottom;
        this.setResult(24);
        this.finish();
    }

    @Override
    @AnimRes
    protected int getExistAnimOfFinish() {
        return this.exitAnimation;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 902: {
                if (resultCode != 12) break;
                this.presenter.sendFiles(data.getStringArrayListExtra("PHOTO_INTENT_KEY"));
                break;
            }
            case 3001: {
                PhotoAlbumStorage.getInstance().release();
                break;
            }
            case 3002: {
                if (resultCode != 23) break;
                this.setResult(23);
            }
        }
    }

    @Override
    public void refreshChatCount(boolean force) {
        if (force) {
            this.getBigBar().setText(CounterSelector.getTotalCounter());
        } else {
            if (this.countSubscription != null && !this.countSubscription.isUnsubscribed()) {
                this.countSubscription.unsubscribe();
            }
            this.countSubscription = Observable.timer((long)600L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Long>(){

                public void call(Long aLong) {
                    ChatActivity2.this.getBigBar().setText(CounterSelector.getTotalCounter());
                }
            });
        }
    }

    private void setInputState(@Nullable Channel channel, boolean onInit) {
        if (channel == null || onInit && !channel.isWorking() && "disabled".equals(channel.getAwayOption())) {
            this.setInputEnable(false);
        }
        if (channel != null && (channel.isWorking() || "active".equals(channel.getAwayOption()))) {
            this.setInputEnable(true);
        }
    }

    private void setInputEnable(boolean enable) {
        Views.setVisibility(this.layoutInput, enable);
        Views.setVisibility((View)this.textDisabled, !enable);
    }

    @Override
    public void refreshMenu(boolean isLocalChat) {
        boolean showBack = !isLocalChat || !UserChatSelector.isEmpty();
        this.getBigBar().setMenuState(MenuButton.ActionType.SETTINGS, !showBack ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.HIDDEN);
        this.getBigBar().setMenuState(MenuButton.ActionType.BACK, showBack ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.HIDDEN);
    }

    @Override
    public void receiveStoreEvent(StoreType storeType, UpdateType updateType, @Nullable Entity entity) {
        this.presenter.receiveStoreEvent(storeType, updateType, entity);
    }

    @Override
    public void receiveCommand(Command command, @Nullable Object object) {
        this.presenter.receiveCommand(command, object);
    }

    @Override
    public void receiveTyping(Typing typing) {
        this.presenter.receiveTyping(typing);
    }

    @Override
    public void receiveLanguageEvent() {
        this.presenter.updateInitMessage();
    }

    @Override
    public void onUserChatChange(@Nullable UserChat oldUserChat, @NonNull UserChat userChat) {
        if (userChat.isStateRemoved()) {
            this.finish();
            return;
        }
        this.chatHeaderView.bindUserChat(userChat);
        this.chatNavigation.bindUserChat(userChat);
        this.refreshMenu(false);
        String userChatState = userChat.getState();
        this.setInputFrameVisibility(CompareUtils.exists((Comparable)((Object)userChatState), (Comparable[])new String[]{"ready", "open", "following", "holding", "continue_chat"}));
        Views.setVisibility((View)this.buttonNewChat, "closed".equals(userChatState));
        if (CompareUtils.exists((Comparable)((Object)userChatState), (Comparable[])new String[]{"solved", "closed"})) {
            this.hideKeyboard((EditText)this.editChat);
        }
        if (oldUserChat != null && !"closed".equals(oldUserChat.getState()) && "closed".equals(userChat.getState())) {
            this.tryScrollToBottom();
        }
        this.viewBottomFloating.bindUserChatState(userChatState);
    }

    @Override
    public void bindChannel(@Nullable Channel channel) {
        this.chatHeaderView.bindChannel(channel);
        this.chatNavigation.bindChannel(channel);
        this.setInputState(channel, false);
    }

    @Override
    public void showInitBanner() {
        this.chatNavigation.bindUserChat(null);
        this.overlayHeaderRecyclerView.postDelayed(new Runnable(){

            @Override
            public void run() {
                ChatActivity2.this.overlayHeaderRecyclerView.showBanner(true);
            }
        }, 400L);
    }

    @Override
    public void onError() {
        this.getBigBar().setMenuState(MenuButton.ActionType.REFRESH, MenuButton.MenuState.VISIBLE);
    }

    @Override
    public void onTryRefresh() {
        this.getBigBar().setMenuState(MenuButton.ActionType.REFRESH, MenuButton.MenuState.HIDDEN);
    }

    @Override
    public void onNewMessageAlertClick() {
        this.scrollToBottom();
    }

    @Override
    public boolean canScrollTop() {
        return this.presenter.hasBackwardMessages();
    }

    @Override
    public void onBannerShow() {
        this.chatHeaderView.setExpand(true);
    }

    @Override
    public void onBannerHide() {
        this.chatHeaderView.setExpand(false);
    }

    @Override
    public void scrollToBottom() {
        this.layoutManager.scrollToPosition(this.adapter.getItemCount() - 1);
    }

    @Override
    public void tryScrollToBottom() {
        if (this.layoutManager.findLastCompletelyVisibleItemPosition() >= this.adapter.getItemCount() - 3) {
            this.scrollToBottom();
        }
    }

    @Override
    public void onHostMessageArrive(@NonNull Message message) {
        if (this.layoutManager.findLastCompletelyVisibleItemPosition() >= this.adapter.getItemCount() - 3) {
            this.scrollToBottom();
        } else {
            this.viewNewMessageAlert.show(ProfileSelector.getHostProfile(message.getPersonType(), message.getPersonId()));
        }
    }

    @Override
    public void setInputFrameVisibility(boolean visibility) {
        Views.setVisibility(this.layoutInputFrame, visibility);
    }

    @Override
    public void setPushBotSaveButtonVisibility(boolean visibility) {
        Views.setVisibility((View)this.pushBotSaveButton, visibility);
    }

    @Override
    public void onWatchedTextChanged(String s) {
        this.buttonSend.setEnabled(!TextUtils.isEmpty((CharSequence)s.trim()));
    }

    @Override
    public void onCountrySelectorClick(ProfileBotMessageItem item, String key, MobileNumber mobileNumber) {
        this.presenter.fetchCountries(item, key, mobileNumber);
    }

    @Override
    public void onCountriesFetch(final ProfileBotMessageItem item, final String key, final MobileNumber mobileNumber) {
        String countryName;
        switch (PrefSupervisor.getPluginLanguage((Context)this)) {
            case "ko": {
                countryName = "South Korea";
                break;
            }
            case "ja": {
                countryName = "Japan";
                break;
            }
            default: {
                countryName = "United States";
            }
        }
        new CountryCodeDialog((Context)this, countryName, new CountryCodeDialog.OnCountryCodeSelectListener(){

            @Override
            public void onCountryCodeSelected(int position, String countryCode) {
                ChatActivity2.this.presenter.selectCountry(item, key, mobileNumber, countryCode);
            }
        }).show();
    }

    @Override
    public void onProfileBotUpdateButtonClick(ProfileBotMessageItem item, String key, Object value) {
        this.presenter.updateProfile(item, key, value);
    }

    @Override
    public void onProfileBotFocusChange(boolean hasFocus) {
        Drawable background = ContextCompat.getDrawable((Context)this, (int)(hasFocus ? R.drawable.ch_plugin_chat_disabled_input_box_bg : R.drawable.ch_plugin_chat_input_box_bg));
        if (Build.VERSION.SDK_INT >= 16) {
            this.layoutInput.setBackground(background);
        } else {
            this.layoutInput.setBackgroundDrawable(background);
        }
    }

    @Override
    public void onProfileBotUpdateComplete() {
        this.editChat.requestFocus();
    }

    @Override
    public void onTranslationButtonClick(Message message) {
        if (message != null) {
            this.presenter.translateMessage(message, PrefSupervisor.getPluginLanguage((Context)this));
        }
    }

    @Override
    public void onImageClick(File file) {
        if (file != null) {
            IntentUtils.setNextActivity((Context)this, PhotoAlbumActivity.class).putExtra("fileId", file.getId()).startActivityForResult(3001);
        }
    }

    @Override
    public void onWebPageClick(String url) {
        if (url != null) {
            Executor.executeLinkAction((Context)this, url, LinkType.URL);
        }
    }

    @Override
    public void onFileClick(File file) {
        if (file != null) {
            if (file.getType() != null && file.getType().startsWith("video")) {
                IntentUtils.setNextActivity((Context)this, VideoViewerActivity.class).putExtra("filename", file.getName()).putExtra("url", file.getUrl()).startActivity();
            } else {
                IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", file.getUrl()).putExtra("filename", file.getFilename()).putExtra("image", file.isImage()).setTransition(Transition.NONE).startActivity();
            }
        }
    }

    @Override
    public void onFormClick(@Nullable String actionType, ActionInput actionInput) {
        this.presenter.sendForm(actionType, actionInput);
    }

    @Override
    public void onResendButtonClick(final SendingMessageItem item) {
        final AlertDialog dialog = new AlertDialog.Builder((Context)this).setMessage((CharSequence)ResUtils.getString("ch.chat.resend.description")).setPositiveButton((CharSequence)ResUtils.getString("ch.chat.retry_sending_message"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ChatActivity2.this.presenter.resend(item);
            }
        }).setNegativeButton((CharSequence)ResUtils.getString("ch.chat.resend.cancel"), null).setNeutralButton((CharSequence)ResUtils.getString("ch.chat.delete"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ChatActivity2.this.presenter.cancelSend(item);
            }
        }).setCancelable(true).create();
        dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface args) {
                int dark = ContextCompat.getColor((Context)ChatActivity2.this, (int)R.color.ch_dark);
                int cobalt = ContextCompat.getColor((Context)ChatActivity2.this, (int)R.color.ch_cobalt);
                dialog.getButton(-1).setTextColor(cobalt);
                dialog.getButton(-2).setTextColor(dark);
                dialog.getButton(-3).setTextColor(dark);
            }
        });
        dialog.show();
    }

    @Override
    public void onRedirectContentsClick(@Nullable String redirectUrl) {
        Executor.executeRedirectUrlAction((Context)this, redirectUrl);
    }

    @Override
    public void onLocalImageClick(@Nullable Previewable previewThumb) {
        if (previewThumb != null) {
            IntentUtils.setNextActivity((Context)this, PhotoAlbumActivity.class).putExtra("localFileUrl", previewThumb.getUrl()).putExtra("localFileViewMode", true).startActivityForResult(3001);
        }
    }
}

