/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.functions.Action0;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorDelay<T>
implements Observable.Operator<T, T> {
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;

    public OperatorDelay(long delay, TimeUnit unit, Scheduler scheduler) {
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        final Scheduler.Worker worker = this.scheduler.createWorker();
        child.add(worker);
        return new Subscriber<T>(child){
            boolean done;

            @Override
            public void onCompleted() {
                worker.schedule(new Action0(){

                    public void call() {
                        if (!done) {
                            done = true;
                            child.onCompleted();
                        }
                    }
                }, OperatorDelay.this.delay, OperatorDelay.this.unit);
            }

            @Override
            public void onError(final Throwable e) {
                worker.schedule(new Action0(){

                    public void call() {
                        if (!done) {
                            done = true;
                            child.onError(e);
                            worker.unsubscribe();
                        }
                    }
                });
            }

            @Override
            public void onNext(final T t) {
                worker.schedule(new Action0(){

                    public void call() {
                        if (!done) {
                            child.onNext(t);
                        }
                    }
                }, OperatorDelay.this.delay, OperatorDelay.this.unit);
            }
        };
    }
}

