package com.zoyi.channel.plugin.android.util.message_format.message;

import android.graphics.Typeface;
import android.support.v4.util.Pair;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;

import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RegexUtils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static com.zoyi.channel.plugin.android.util.message_format.message.EscapeMessage.ESCAPE_POSTFIX;
import static com.zoyi.channel.plugin.android.util.message_format.message.EscapeMessage.ESCAPE_PREFIX;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class UnescapeMessage implements MessagePattern{

  private Pattern unescapePattern = Pattern.compile(ESCAPE_PREFIX + "[\\d]+" + ESCAPE_POSTFIX);

  @Override
  public SpannableStringBuilder parse(SpannableStringBuilder span) {

    String plainText = span.toString();

    for (Pair<Integer, Integer> range : RegexUtils.getReversedRange(unescapePattern.matcher(span))) {
      int start = range.first;
      int end = range.second;

      String escape = asciiToString(plainText.substring(start + ESCAPE_PREFIX.length(), end - ESCAPE_POSTFIX.length()));
      span.delete(start, end);
      span.insert(start, escape);
    }

    return span;
  }

  private String asciiToString(String ascii) {
    int asciiNum;
    String asciiChar;

    asciiNum = Integer.decode(ascii);

    asciiChar = Character.toString((char) asciiNum);
    return asciiChar;
  }
}
