package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.persistentcookiejar.ClearableCookieJar;
import com.zoyi.channel.plugin.android.util.persistentcookiejar.PersistentCookieJar;
import com.zoyi.channel.plugin.android.util.persistentcookiejar.cache.SetCookieCache;
import com.zoyi.channel.plugin.android.util.persistentcookiejar.persistence.SharedPrefsCookiePersistor;
import com.zoyi.okhttp3.OkHttpClient;
import com.zoyi.okhttp3.logging.HttpLoggingInterceptor;
import com.zoyi.retrofit2.Retrofit;
import com.zoyi.retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import com.zoyi.retrofit2.converter.gson.GsonConverterFactory;

/**
 * Created by mika on 2016. 1. 20..
 */
public class ServiceFactory {

//  static String REST_END_POINT = "http://api.exp.channel.io/";
  static String REST_END_POINT = "https://api.channel.io/";

  public static ChannelApi create() {
    HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor()
        .setLevel(ChannelIO.isDebugMode()
            ? HttpLoggingInterceptor.Level.BODY
            : HttpLoggingInterceptor.Level.NONE);

    OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder()
        .addInterceptor(new RetrofitInterceptor())
        .addInterceptor(new UserAgentInterceptor())
        .addInterceptor(new TokenInterceptor())
        .addInterceptor(new ServerTimeInterceptor())
        .addInterceptor(loggingInterceptor);

    if (ChannelIO.getAppContext() != null) {
      ClearableCookieJar cookieJar = new PersistentCookieJar(
          new SetCookieCache(),
          new SharedPrefsCookiePersistor(ChannelIO.getAppContext()));

      clientBuilder.cookieJar(cookieJar);
    }

    OkHttpClient client = clientBuilder.build();

    return new Retrofit.Builder()
        .baseUrl(REST_END_POINT)
        .client(client)
        .addCallAdapterFactory(RxJavaCallAdapterFactory.create())
        .addConverterFactory(GsonConverterFactory.create(ParseUtils.getCustomGson()))
        .build()
        .create(ChannelApi.class);
  }
}
