/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.push_bot.OnPushBotClickListener;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.channel.plugin.android.view.popup.BasePopupView;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

public class PushBotPopupView
extends BasePopupView {
    private static final int MAX_PUSH_BOT_IMAGE_HEIGHT = 220;
    private ViewGroup layoutPushBotPopupImage;
    private ImageView imagePushBotPopupImage;
    private MaskableFrameLayout layoutPushBotPopupButton;
    private TextView textPushBotPopupButton;
    @Nullable
    private OnPushBotClickListener onPushBotClickListener;
    @Nullable
    private PushBotItem pushBotItem;

    public PushBotPopupView(@NonNull Context context) {
        super(context);
    }

    public PushBotPopupView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PushBotPopupView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init(Context context) {
        super.init(context);
        this.layoutPushBotPopupImage = (ViewGroup)this.root.findViewById(R.id.ch_layout_popup_image);
        this.imagePushBotPopupImage = (ImageView)this.root.findViewById(R.id.ch_image_popup_image);
        this.layoutPushBotPopupButton = (MaskableFrameLayout)this.root.findViewById(R.id.ch_layout_popup_button);
        this.textPushBotPopupButton = (TextView)this.root.findViewById(R.id.ch_text_popup_button);
        this.root.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PushBotPopupView.this.pushBotItem != null && PushBotPopupView.this.onPushBotClickListener != null) {
                    PushBotPopupView.this.onPushBotClickListener.onPushBotClick(PushBotPopupView.this.pushBotItem.getId());
                }
                PushBotPopupView.this.hide();
            }
        });
        this.layoutPushBotPopupImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PushBotPopupView.this.pushBotItem != null && PushBotPopupView.this.onPushBotClickListener != null) {
                    PushBotPopupView.this.onPushBotClickListener.onPushBotContentsClick(PushBotPopupView.this.pushBotItem.getId(), PushBotPopupView.this.pushBotItem.getImageRedirectUrl());
                }
                PushBotPopupView.this.hide();
            }
        });
        this.layoutPushBotPopupButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PushBotPopupView.this.pushBotItem != null && PushBotPopupView.this.onPushBotClickListener != null) {
                    PushBotPopupView.this.onPushBotClickListener.onPushBotContentsClick(PushBotPopupView.this.pushBotItem.getId(), PushBotPopupView.this.pushBotItem.getButtonRedirectUrl());
                }
                PushBotPopupView.this.hide();
            }
        });
    }

    public void setPushBotClickListener(OnPushBotClickListener onPushBotClickListener) {
        this.onPushBotClickListener = onPushBotClickListener;
    }

    public void show(@NonNull PushBotItem pushBotItem) {
        this.pushBotItem = pushBotItem;
        super.bindPopupData(pushBotItem);
        this.bindPushBotItem(pushBotItem);
        this.root.setVisibility(0);
    }

    private void bindPushBotItem(@NonNull PushBotItem pushBotItem) {
        if (pushBotItem.getAttachment() != null) {
            switch (pushBotItem.getAttachment()) {
                case "button": {
                    if (pushBotItem.getButtonTitle() == null) break;
                    this.textPushBotPopupButton.setBackgroundColor(ColorSelector.getBackgroundColor());
                    this.textPushBotPopupButton.setText((CharSequence)pushBotItem.getButtonTitle());
                    this.layoutPushBotPopupButton.setVisibility(0);
                    break;
                }
                case "image": {
                    PreviewThumb imagePreview = pushBotItem.getImageThumb();
                    if (imagePreview == null || imagePreview.getUrl() == null) break;
                    if (imagePreview.getHeight() > 220) {
                        ViewGroup.LayoutParams layoutParams = this.imagePushBotPopupImage.getLayoutParams();
                        layoutParams.height = (int)Utils.dpToPx(220.0f);
                        this.imagePushBotPopupImage.setLayoutParams(layoutParams);
                    }
                    Glide.with((Context)this.context).load(imagePreview.getUrl()).centerCrop().diskCacheStrategy(DiskCacheStrategy.SOURCE).into(this.imagePushBotPopupImage);
                    this.layoutPushBotPopupImage.setVisibility(0);
                }
            }
        }
    }
}

