/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network;

import com.splunk.mint.network.Metric;

public class Timer
extends Metric<Long> {
    private Long start = null;
    private Long end = 0L;

    public Timer(String name) {
        super(name + "-timer");
    }

    public void start() {
        if (this.start == null) {
            this.start = System.currentTimeMillis();
        }
    }

    public void done() {
        this.end = System.currentTimeMillis();
    }

    public long getStartValue() {
        if (this.start == null) {
            return 0L;
        }
        return this.start;
    }

    public long getStopValue() {
        return this.end;
    }

    @Override
    public Long getValue() {
        if (this.start == null) {
            return null;
        }
        if (this.end != null) {
            return this.end - this.start;
        }
        return System.currentTimeMillis() - this.start;
    }
}

