package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.settings.setting_language.listener.OnLanguageItemClickListener;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;

public class SelectableLanguageItem extends RelativeLayout implements View.OnClickListener {

  private Context context;

  private CHTextView languageText;
  private ImageView checkImage;

  @Nullable
  private CHLocale channelLanguage;

  @Nullable
  private OnLanguageItemClickListener onLanguageItemClickListener;

  public SelectableLanguageItem(Context context) {
    super(context);
    this.context = context;
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_item_selectable_lang, this);

    languageText = view.findViewById(R.id.ch_text_selectable_lang);
    checkImage = view.findViewById(R.id.ch_img_selectable_lang_chcek);

    view.findViewById(R.id.ch_root_selectable_lang).setOnClickListener(this);
  }

  public void setListener(OnLanguageItemClickListener onLanguageItemClickListener) {
    this.onLanguageItemClickListener = onLanguageItemClickListener;
  }

  @Nullable
  public CHLocale getLanguage() {
    return channelLanguage;
  }

  public void setLanguage(@Nullable CHLocale channelLanguage) {
    if (channelLanguage != null) {
      this.channelLanguage = channelLanguage;

      switch (this.channelLanguage) {
        case KOREAN:
          setLanguageText(ResUtils.getString(context, "ko"));
          break;
        case JAPANESE:
          setLanguageText(ResUtils.getString(context, "ja"));
          break;
        default:
          setLanguageText(ResUtils.getString(context, "en"));
          break;
      }
    } else {
      this.channelLanguage = CHLocale.fromString(PrefSupervisor.getPluginLanguage(context));
    }
  }

  private void setLanguageText(String text) {
    languageText.setText(text);
  }

  private void setCheckVisibility(boolean isClicked) {
    checkImage.setVisibility(UIUtils.getVisible(isClicked, true));
  }

  private void setTextColor(boolean isClicked) {
    int textColor =
        isClicked?
        ContextCompat.getColor(context, R.color.ch_dark) :
        ContextCompat.getColor(context, R.color.ch_light);

    languageText.setTextColor(textColor);
  }

  public void setSelectedLanguage(boolean isSelectedLanguage) {
    if(isSelectedLanguage) {
      setStyle(true);
    }
  }

  public void setStyle(boolean isSelectedItem) {
    setCheckVisibility(isSelectedItem);
    setTextColor(isSelectedItem);
  }

  @Override
  public void onClick(View view) {
    int viewId = view.getId();

    if (viewId == R.id.ch_root_selectable_lang) {
      setStyle(true);

      if (onLanguageItemClickListener != null && getLanguage() != null) {
        onLanguageItemClickListener.onItemClick(getLanguage());
      }
    }
  }
}
