package com.zoyi.channel.plugin.android.selector;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.store.BotStore;
import com.zoyi.channel.plugin.android.store.Store;

import java.util.List;

/**
 * Created by mika on 2018. 6. 21..
 */

public class BotSelector extends BaseSelector {

  @Nullable
  public static Bot getDefaultBot() {
    if (getDefaultBotId() != null) {
      return Store.getInstance(BotStore.class).get(getDefaultBotId());
    }
    return null;
  }

  @Nullable
  public static Bot getBotByName(@Nullable String name) {
    if (name == null) {
      return null;
    }

    List<Bot> bots = Store.getInstance(BotStore.class).get();

    for (Bot bot : bots) {
      if (name.equals(bot.getName())) {
        return bot;
      }
    }

    return null;
  }

  @Nullable
  public static String getDefaultBotId() {
    return Store.getInstance(BotStore.class).getDefaultBotId();
  }
}
