package com.zoyi.channel.plugin.android.model;

import android.text.SpannableStringBuilder;

import com.zoyi.channel.plugin.android.enumerate.TranslationState;
import com.zoyi.channel.plugin.android.model.entity.Entity;

/**
 * Created by jerry on 2018. 7. 9..
 */

public class TranslationInfo implements Entity {
  private String id;
  private SpannableStringBuilder translatedMessage;
  private TranslationState state;

  public TranslationInfo(String id, SpannableStringBuilder translatedMessage, TranslationState state) {
    this.id = id;
    this.translatedMessage = translatedMessage;
    this.state = state;
  }
  public SpannableStringBuilder getTranslatedMessage() {
    return translatedMessage;
  }

  public TranslationState getState() {
    return state;
  }

  public void setState(TranslationState state) {
    this.state = state;
  }

  @Override
  public String getId() {
    return id;
  }

  public static String createId(String messageId, String language) {
    return String.format("%s:%s", messageId, language);
  }

  public static TranslationInfo createProgressStateInfo(String id) {
    return new TranslationInfo(id, null, TranslationState.PROGRESS);
  }

  public static TranslationInfo createOriginStateInfo(String id) {
    return new TranslationInfo(id, null, TranslationState.ORIGIN);
  }
}
