package com.zoyi.channel.plugin.android.activity.chat.view.overlayheader;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.view.handler.OnSizeChangeListener;

/**
 * Created by mika on 2018. 10. 24..
 */

public class SizeObservableFrameLayout extends FrameLayout {

  @Nullable
  private OnSizeChangeListener sizeChangeListener;
  @Nullable
  private OnTouchListener touchListener;

  private int height = 0;

  public SizeObservableFrameLayout(@NonNull Context context) {
    super(context);
  }

  public SizeObservableFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public SizeObservableFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @Override
  protected void onSizeChanged(final int w, final int h, final int oldw, final int oldh) {
    super.onSizeChanged(w, h, oldw, oldh);

    if (h != height) {
      height = h;
      postDelayed(new Runnable() {
        @Override
        public void run() {
          if (sizeChangeListener != null) {
            sizeChangeListener.onSizeChange(w, h, oldw, oldh);
          }
        }
      }, 1);
    }
  }

  public int getLastHeight() {
    return height;
  }

  @SuppressLint("ClickableViewAccessibility")
  @Override
  public boolean onTouchEvent(MotionEvent event) {
    if (touchListener != null) {
      return touchListener.onTouch(getRootView(), event);
    }
    return false;
  }

  public void setOnSizeChangeListener(@Nullable OnSizeChangeListener listener) {
    this.sizeChangeListener = listener;
  }
}
