/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.deserializer.MessageDeserializer;
import com.zoyi.channel.plugin.android.deserializer.TranslationRepoDeserializer;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.wrapper.TranslationRepo;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.message_format.MessageParser;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.com.google.gson.GsonBuilder;

public class ParseUtils {
    @Nullable
    private static Gson gson;

    public static Gson getCustomGson() {
        if (gson == null) {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(Message.class, (Object)new MessageDeserializer());
            builder.registerTypeAdapter(TranslationRepo.class, (Object)new TranslationRepoDeserializer());
            gson = builder.create();
        }
        return gson;
    }

    @Nullable
    public static SpannableStringBuilder parseMessage(String message) {
        MessageParser parser = MessageParser.get();
        if (TextUtils.isEmpty((CharSequence)message) || parser == null) {
            return new SpannableStringBuilder((CharSequence)"");
        }
        return parser.parse(message);
    }

    @Nullable
    public static <T> T parseJson(String entity, Class<T> target) {
        try {
            return (T)ParseUtils.getCustomGson().fromJson(entity, target);
        }
        catch (Exception ex) {
            L.e(ex.getMessage());
            return null;
        }
    }
}

