/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.video;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageButton;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.util.Util;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.util.IntentUtils;

public class VideoViewerActivity
extends BaseActivity {
    private PlayerView videoPlayerView;
    private ImageButton downloadButton;
    @Nullable
    private SimpleExoPlayer exoPlayer;
    private String url;
    private String fileName;
    private long lastPosition;
    private boolean playWhenReady;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.activity_video_loader, -16777216, -1);
        this.url = this.getIntent().getStringExtra("url");
        this.fileName = this.getIntent().getStringExtra("filename");
        this.videoPlayerView = (PlayerView)this.findViewById(R.id.view_video_player);
        this.downloadButton = (ImageButton)this.findViewById(R.id.exo_download);
        if (this.url != null && this.fileName != null) {
            this.downloadButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    IntentUtils.setNextActivity((Context)VideoViewerActivity.this, DownloadActivity.class).putExtra("url", VideoViewerActivity.this.url).putExtra("filename", VideoViewerActivity.this.fileName).putExtra("image", false).setTransition(Transition.NONE).startActivity();
                }
            });
            DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter();
            AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory((BandwidthMeter)bandwidthMeter);
            DefaultTrackSelector trackSelector = new DefaultTrackSelector((TrackSelection.Factory)videoTrackSelectionFactory);
            this.exoPlayer = ExoPlayerFactory.newSimpleInstance((RenderersFactory)new DefaultRenderersFactory((Context)this), (TrackSelector)trackSelector);
            this.videoPlayerView.setPlayer((Player)this.exoPlayer);
            DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory((Context)this, Util.getUserAgent((Context)this, (String)"ChannelDesk"));
            ExtractorMediaSource videoSource = new ExtractorMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(Uri.parse((String)this.url));
            this.exoPlayer.prepare((MediaSource)videoSource);
        } else {
            this.finish();
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (this.exoPlayer != null) {
            this.exoPlayer.seekTo(this.lastPosition);
            this.exoPlayer.setPlayWhenReady(this.playWhenReady);
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (this.exoPlayer != null) {
            this.lastPosition = this.exoPlayer.getCurrentPosition();
            this.playWhenReady = this.exoPlayer.getPlayWhenReady();
            this.exoPlayer.setPlayWhenReady(false);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.exoPlayer != null) {
            this.exoPlayer.release();
            this.exoPlayer = null;
        }
    }
}

