package com.zoyi.channel.plugin.android.model.etc;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.util.TimeUtils;

public class Typing {

  public static final long TTL = 30;

  private String action;
  private String chatId;
  private String chatType;
  private String personId;
  private String personType;
  private Long createdAt;

  public Typing(String action, String chatId, String chatType) {
    this.action = action;
    this.chatId = chatId;
    this.chatType = chatType;
  }

  public String getAction() {
    return action;
  }

  public void setAction(String action) {
    this.action = action;
  }

  public void setCreatedAt(Long createdAt) {
    this.createdAt = createdAt;
  }

  public boolean isOther() {
    // All of host applied
    return Const.MANAGER.equals(personType) || Const.BOT.equals(personType);
  }

  public boolean isExpired() {
    return createdAt != null && (TimeUtils.getCurrentTime() - createdAt >= TTL);
  }

  public String getKey() {
    return String.format("%s:%s:%s:%s", chatId, chatType, personId, personType);
  }

  public ProfileEntity getProfileEntity() {
    return ProfileSelector.getHostProfile(personType, personId);
  }

  public boolean isSameChat(String chatId, String chatType) {
    return this.chatId.equals(chatId) && this.chatType.equals(chatType);
  }

  @Override
  public boolean equals(Object o) {
    boolean ret = false;
    if (o != null && o instanceof Typing) {
      Typing next = (Typing) o;

      ret = this.chatId.equals(next.chatId)
          && this.chatType.equals(next.chatType)
          && this.personId.equals(next.personId)
          && this.personType.equals(next.personType);
    }
    return ret;
  }
}
