package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;

/**
 * Created by mika on 2018. 6. 22..
 */

public class WelcomeMessageHolder extends TextMessageHolder {

  public static WelcomeMessageHolder newInstance(ViewGroup parent) {
    return new WelcomeMessageHolder(getItemView(parent, MessageType.WELCOME));
  }

  private WelcomeMessageHolder(View itemView) {
    super(itemView, MessageType.WELCOME);
  }

  public void bind(WelcomeMessageItem item) {
    super.bind(item.getMessage(), MessageType.WELCOME, false);

    setHostMessageText(item.getMessage().getFormattedSpanMessage(), false);
  }
}
