/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

public class ColorFilterImageView
extends FrameLayout {
    private View root;
    private MaskableFrameLayout maskColorFilterImageView;
    private View backgroundColorFilterImageView;

    public ColorFilterImageView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public ColorFilterImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ColorFilterImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    public void init(Context context, @Nullable AttributeSet attrs) {
        this.root = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_color_filter_image, (ViewGroup)this, true);
        this.maskColorFilterImageView = (MaskableFrameLayout)this.root.findViewById(R.id.ch_mask_color_filter_image);
        this.backgroundColorFilterImageView = this.root.findViewById(R.id.ch_view_color_filter_image_background);
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ColorFilterImageView, 0, 0);
            try {
                int color2 = typedArray.getColor(R.styleable.ColorFilterImageView_color, -16777216);
                Drawable image = typedArray.getDrawable(R.styleable.ColorFilterImageView_image);
                this.setColor(color2);
                this.setImage(image);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public void setImage(@Nullable Drawable image) {
        if (image != null) {
            this.maskColorFilterImageView.setMask(image);
        }
    }

    public void setColor(int color2) {
        this.backgroundColorFilterImageView.setBackgroundColor(color2);
    }
}

