package com.zoyi.channel.plugin.android.store;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.enumerate.StoreType;

/**
 * Created by jerry on 2018. 9. 6..
 */

public class UiStateStore extends Store implements DestroyableStore {

  private boolean launcherVisible = false;
  private boolean closedChatVisible = false;

  @Nullable
  private Context activityToShowInAppPush;

  public void setLauncherVisible(boolean visible) {
    this.launcherVisible = visible;
  }

  public boolean getLauncherVisible() {
    return launcherVisible;
  }

  public boolean shouldShowClosedChat() {
    return closedChatVisible;
  }

  public void setClosedChatVisible(boolean closedChatVisible) {
    this.closedChatVisible = closedChatVisible;
  }

  @Nullable
  public Context getActivityToShowInAppPush() {
    return activityToShowInAppPush;
  }

  public void setActivityToShowInAppPush(@Nullable Context activityToShowInAppPush) {
    this.activityToShowInAppPush = activityToShowInAppPush;
  }

  @NonNull
  @Override
  protected StoreType getStoreType() {
    return StoreType.GLOBAL_VIEW;
  }


  @Override
  public void clearData() {
    // launcherVisible, closedChatVisible shouldn't reset.
    activityToShowInAppPush = null;
  }
}
