package com.zoyi.channel.plugin.android.model.rest;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.Guest;

import java.util.Map;

/**
 * Created by mika on 2017. 1. 16..
 */
public class User implements Guest {
  private String id;
  private String name;
  private String mobileNumber;
  private String avatarUrl;
  private Object meta;
  private Boolean named;
  private Long createdAt;
  private Long updatedAt;
  private String segment;
  private String country;
  private String city;
  private Map<String, Object> profile;
  private int alert;

  @Override
  public String getId() {
    return id;
  }

  @NonNull
  @Override
  public String getName() {
    return name != null ? name : "";
  }

  @Override
  public String getAvatarUrl() {
    return avatarUrl;
  }

  @Override
  public String getMobileNumber() {
    return mobileNumber;
  }

  @Override
  public String getSegment() {
    return segment;
  }

  @Override
  public String getCountry() {
    return country;
  }

  @Override
  public String getCity() {
    return city;
  }

  public final static String CLASSNAME = "User";

  @Override
  public boolean isNamed() {
    return named == null ? false : named;
  }

  @Override
  public long getCreatedAt() {
    if (createdAt != null) {
      return createdAt;
    }

    return 0L;
  }

  @Override
  public long getUpdatedAt() {
    if (updatedAt != null) {
      return updatedAt;
    }

    return 0L;
  }

  @Override
  public int getAlert() {
    return alert;
  }

  @Override
  public Map<String, Object> getProfile() {
    return profile;
  }

  @Override
  public Object getProfileValue(String key) {
    if (profile != null) {
      return profile.get(key);
    } else {
      return null;
    }
  }

  @Override
  public String getPersonType() {
    return Const.USER;
  }

  @Override
  public String getPersonId() {
    return id;
  }

  @Override
  public boolean isOwnedBy(@Nullable String personType, @Nullable String personId) {
    return Const.USER.equals(personType) && personId != null && personId.equals(id);
  }
}
