/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ConnectableMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.ContentType;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.ActionInput;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Utils;

public class SendingMessageItem
extends ConnectableMessageItem
implements MessageItem {
    @Nullable
    private String chatId;
    private String requestId;
    @Nullable
    private String text;
    @Nullable
    private String filePath;
    @Nullable
    private String actionType;
    @Nullable
    private ActionInput actionInput;
    private ContentType contentType;
    private boolean sending;
    private Long createdAt = TimeUtils.getCurrentTime();

    @Nullable
    public static SendingMessageItem createDummy(@Nullable String requestId) {
        if (requestId == null) {
            return null;
        }
        SendingMessageItem item = new SendingMessageItem();
        item.requestId = requestId;
        try {
            item.createdAt = Long.parseLong(requestId.substring(0, 13));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return item;
    }

    @NonNull
    public static SendingMessageItem copyContentFrom(@Nullable SendingMessageItem item) {
        if (item != null) {
            return new SendingMessageItem(item);
        }
        return new SendingMessageItem();
    }

    public SendingMessageItem() {
        this.requestId = "";
        this.contentType = ContentType.NONE;
    }

    public SendingMessageItem(@Nullable String chatId) {
        this.requestId = this.createdAt + Utils.getRandomString(4);
        this.chatId = chatId;
        this.sending = true;
        this.contentType = ContentType.NONE;
    }

    private SendingMessageItem(@NonNull SendingMessageItem item) {
        this.requestId = this.createdAt + Utils.getRandomString(4);
        this.chatId = item.getChatId();
        this.text = item.getText();
        this.filePath = item.getFilePath();
        this.actionInput = item.getActionInput();
        this.contentType = item.getContentType();
        this.sending = true;
    }

    @Override
    public Long getPrimaryKey() {
        return this.createdAt * 10L;
    }

    @Override
    public String getSecondaryKey() {
        return this.requestId;
    }

    @NonNull
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public MessageType getType() {
        return MessageType.SENDING;
    }

    @Nullable
    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @Override
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public boolean isSending() {
        return this.sending;
    }

    public void setSending(boolean sending) {
        this.sending = sending;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    public SendingMessageItem setText(@Nullable String text) {
        if (text != null) {
            this.text = text;
            this.contentType = ContentType.TEXT;
        }
        return this;
    }

    @Nullable
    public String getFilePath() {
        return this.filePath;
    }

    public SendingMessageItem setFilePath(@Nullable String filePath) {
        if (filePath != null) {
            this.filePath = filePath;
            this.contentType = ContentType.FILE;
        }
        return this;
    }

    @Nullable
    public String getActionType() {
        return this.actionType;
    }

    @Nullable
    public ActionInput getActionInput() {
        return this.actionInput;
    }

    public SendingMessageItem setActionInput(@Nullable String actionType, @Nullable ActionInput actionInput) {
        if (actionType != null && actionInput != null) {
            this.actionType = actionType;
            this.actionInput = actionInput;
            this.contentType = ContentType.FORM;
        }
        return this;
    }

    public void updateMessageOnActionInput(@NonNull Message message) {
        if (this.contentType == ContentType.FORM && this.actionInput != null) {
            this.actionInput.setMessage(message);
        }
    }

    @Override
    public boolean isSamePerson(@NonNull ConnectableMessageItem item) {
        if (item instanceof SendingMessageItem) {
            return true;
        }
        if (item instanceof ChatMessageItem) {
            return ((ChatMessageItem)item).getType() == MessageType.GUEST;
        }
        return false;
    }
}

