/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Func2;
import com.zoyi.rx.observers.SerializedSubscriber;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorWithLatestFrom<T, U, R>
implements Observable.Operator<R, T> {
    final Func2<? super T, ? super U, ? extends R> resultSelector;
    final Observable<? extends U> other;
    static final Object EMPTY = new Object();

    public OperatorWithLatestFrom(Observable<? extends U> other, Func2<? super T, ? super U, ? extends R> resultSelector) {
        this.other = other;
        this.resultSelector = resultSelector;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super R> child) {
        final SerializedSubscriber<R> s = new SerializedSubscriber<R>(child, false);
        child.add(s);
        final AtomicReference<Object> current = new AtomicReference<Object>(EMPTY);
        Subscriber subscriber = new Subscriber<T>(s, true){

            @Override
            public void onNext(T t) {
                Object o = current.get();
                if (o != EMPTY) {
                    try {
                        Object u = o;
                        Object result = OperatorWithLatestFrom.this.resultSelector.call(t, u);
                        s.onNext(result);
                    }
                    catch (Throwable e) {
                        Exceptions.throwOrReport(e, this);
                    }
                }
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
                s.unsubscribe();
            }

            @Override
            public void onCompleted() {
                s.onCompleted();
                s.unsubscribe();
            }
        };
        Subscriber otherSubscriber = new Subscriber<U>(){

            @Override
            public void onNext(U t) {
                current.set(t);
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
                s.unsubscribe();
            }

            @Override
            public void onCompleted() {
                if (current.get() == EMPTY) {
                    s.onCompleted();
                    s.unsubscribe();
                }
            }
        };
        s.add(subscriber);
        s.add(otherSubscriber);
        this.other.unsafeSubscribe(otherSubscriber);
        return subscriber;
    }
}

