/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.push;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationManagerCompat;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelApiManager;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.push.NotificationFactory;
import com.zoyi.channel.plugin.android.push.PushData;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.Map;

public class ChannelPushManager {
    private static final int NOTIFICATION_ID = 0x3FFFFFFF;

    private static Bundle convertMessageMapToBundle(Map<String, String> message) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : message.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }

    public static boolean isChannelPushNotification(Map<String, String> message) {
        return ChannelPushManager.isChannelPushNotification(ChannelPushManager.convertMessageMapToBundle(message));
    }

    public static boolean isChannelPushNotification(Bundle message) {
        if (message == null) {
            return false;
        }
        PushData pushData = new PushData(message);
        return pushData.isChannelPluginMessage();
    }

    public static void sendTokenToChannelIO(@Nullable Context context) {
        if (context != null) {
            String token = PrefSupervisor.getDeviceToken(context);
            String sentToken = PrefSupervisor.getSentDeviceToken(context);
            if (!TextUtils.isEmpty((CharSequence)token) && !CompareUtils.isSame(token, sentToken)) {
                PrefSupervisor.setSentDeviceToken(context, token);
                RequestBody body = RequestUtils.form().set("platform", "android").set("key", ChannelPushManager.getDeviceId(context)).set("token", token).create();
                ChannelApiManager.get().sendToken(body).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new RestSubscriber());
            }
        }
    }

    @SuppressLint(value={"HardwareIds"})
    public static void deleteToken(Context context, @Nullable String jwt) {
        if (jwt != null) {
            ChannelApiManager.get().deleteToken(jwt, "android", ChannelPushManager.getDeviceId(context)).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new RestSubscriber());
        }
        PrefSupervisor.setSentDeviceToken(context, null);
    }

    @SuppressLint(value={"HardwareIds"})
    private static String getDeviceId(Context context) {
        String key = PrefSupervisor.getDeviceId(context);
        if (TextUtils.isEmpty((CharSequence)key)) {
            key = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            PrefSupervisor.setDeviceId(context, key);
        }
        return key;
    }

    public static void showPushNotification(Context context, Map<String, String> message) {
        ChannelPushManager.showPushNotification(context, ChannelPushManager.convertMessageMapToBundle(message));
    }

    public static void showPushNotification(Context context, Bundle message) {
        if (PrefSupervisor.hasBootFlag(context)) {
            String personId = message.getString("personId");
            String personType = message.getString("personType");
            if (CompareUtils.isSame(personType, PrefSupervisor.getGuestType(context)) && CompareUtils.exists((Comparable)((Object)personId), (Comparable[])new String[]{PrefSupervisor.getGuestId(context)})) {
                ChannelPushManager.sendNotification(context, message);
                if (message.getString("chatId") != null) {
                    ChannelPushManager.receivePushNotification(message.getString("chatId"));
                }
            }
        }
    }

    private static void sendNotification(Context context, Bundle message) {
        Notification notification = NotificationFactory.createPushMessage(context, new PushData(message));
        if (notification != null) {
            NotificationManagerCompat.from((Context)context).notify(0x3FFFFFFF, notification);
        }
    }

    private static void receivePushNotification(String chatId) {
        ChannelApiManager.get().receivePushNotification(chatId).onBackpressureBuffer().subscribeOn(Schedulers.io()).subscribe(new RestSubscriber());
    }

    static void clearNotification(Context context) {
        try {
            NotificationManagerCompat.from((Context)context).cancel(0x3FFFFFFF);
        }
        catch (Exception ex) {
            L.e(ex.getMessage());
        }
    }
}

