/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.settings;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.ChannelLayout;

public class SettingsHeaderFragment
extends Fragment
implements View.OnClickListener {
    private Context context;
    private ChannelLayout layoutChannelImage;
    private CHTextView textChannelName;
    private View layoutMenu;
    private ImageView homepage;
    private ImageView phone;
    @Nullable
    private Channel channel;
    @Nullable
    private Plugin plugin;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.ch_plugin_fragment_settings_header, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.context = this.getActivity();
        this.channel = ChannelSelector.getCurrentChannel();
        this.plugin = PluginSelector.getPlugin();
        this.layoutChannelImage = (ChannelLayout)view.findViewById(R.id.layout_channel_image);
        this.textChannelName = (CHTextView)view.findViewById(R.id.tv_channel_name);
        this.layoutMenu = view.findViewById(R.id.layout_settings_menu);
        this.homepage = (ImageView)view.findViewById(R.id.iv_menu_homepage);
        this.phone = (ImageView)view.findViewById(R.id.iv_menu_phone);
        if (this.channel != null && this.plugin != null) {
            view.setBackgroundColor(Color.parseColor((String)this.plugin.getBorderColor()));
            this.setChannelImage(this.channel, this.plugin);
            this.textChannelName.setText(this.channel.getName());
            this.textChannelName.setTextColor(ColorSelector.getTextColor());
            this.homepage.setOnClickListener((View.OnClickListener)this);
            this.phone.setOnClickListener((View.OnClickListener)this);
            this.decorateMenu();
        }
    }

    public void onClick(View v) {
        ChannelDialog channelDialog;
        int id2 = v.getId();
        if (id2 == R.id.iv_menu_homepage && this.context != null && this.channel != null) {
            final String homepageURL = this.channel.getHomepageUrl();
            channelDialog = new ChannelDialog(this.context);
            ((ChannelDialog)((Object)((ChannelDialog)((Object)channelDialog.setDescription(homepageURL).addButton(ButtonType.CANCEL))).addButton(ButtonType.OK, new View.OnClickListener(){

                public void onClick(View v) {
                    IntentUtils.setUrl(SettingsHeaderFragment.this.context, homepageURL).startActivity();
                }
            }))).show();
        }
        if (id2 == R.id.iv_menu_phone && this.context != null && this.channel != null) {
            final String phoneNumber = this.channel.getPhoneNumber();
            channelDialog = new ChannelDialog(this.context);
            ((ChannelDialog)((Object)((ChannelDialog)((Object)channelDialog.setDescription(phoneNumber).addButton(ButtonType.CANCEL))).addButton(ButtonType.OK, new View.OnClickListener(){

                public void onClick(View v) {
                    Executor.call(SettingsHeaderFragment.this.context, phoneNumber);
                }
            }))).show();
        }
    }

    private void setChannelImage(Channel channel, Plugin plugin) {
        if (TextUtils.isEmpty((CharSequence)channel.getAvatarUrl())) {
            this.layoutChannelImage.set(channel, plugin);
        } else {
            this.layoutChannelImage.set(channel);
        }
    }

    private void decorateMenu() {
        if (this.channel != null && this.plugin != null) {
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.textChannelName.getLayoutParams();
            String homepageUrl = this.channel.getHomepageUrl();
            String phoneNumber = this.channel.getPhoneNumber();
            if (TextUtils.isEmpty((CharSequence)homepageUrl) && TextUtils.isEmpty((CharSequence)phoneNumber)) {
                this.layoutMenu.setVisibility(8);
                params.bottomMargin = (int)Utils.dpToPx(this.context, 20.0f);
            } else {
                int textColorInt = ColorSelector.getTextColor();
                this.homepage.setBackgroundResource(this.getBackgroundDrawableRes(textColorInt));
                this.homepage.setColorFilter(textColorInt);
                this.homepage.setVisibility(UIUtils.getVisible(!TextUtils.isEmpty((CharSequence)homepageUrl), true));
                this.phone.setBackgroundResource(this.getBackgroundDrawableRes(textColorInt));
                this.phone.setColorFilter(textColorInt);
                this.phone.setVisibility(UIUtils.getVisible(!TextUtils.isEmpty((CharSequence)phoneNumber), true));
                this.layoutMenu.setVisibility(0);
                this.setMenuMargin();
                params.bottomMargin = (int)Utils.dpToPx(this.context, 16.0f);
            }
            this.textChannelName.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void setMenuMargin() {
        if (this.phone.getVisibility() == 0) {
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.homepage.getLayoutParams();
            params.rightMargin = (int)Utils.dpToPx(this.context, 14.0f);
            this.homepage.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    @DrawableRes
    private int getBackgroundDrawableRes(int textColorInt) {
        return textColorInt == -1 ? R.drawable.ch_plugin_settings_menu_bright_bg : R.drawable.ch_plugin_settings_menu_dark_bg;
    }
}

