/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.view.form.FormButtonLayout;
import com.zoyi.channel.plugin.android.activity.chat.view.form.FormButtonView;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.TextMessageHolder;
import com.zoyi.channel.plugin.android.enumerate.TranslationState;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.ActionInput;
import com.zoyi.channel.plugin.android.model.Form;
import com.zoyi.channel.plugin.android.model.TranslationInfo;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.selector.TranslationSelector;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.util.draw.Resizer;
import com.zoyi.channel.plugin.android.view.external.cpv.CircularProgressView;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.zoyi.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.zoyi.com.bumptech.glide.request.RequestListener;
import com.zoyi.com.bumptech.glide.request.target.Target;
import java.util.List;

public abstract class ContentMessageHolder
extends TextMessageHolder {
    private View rootContentMessageFile;
    private ImageView imageContentMessageFile;
    private CHTextView textContentMessageFileName;
    private CHTextView textContentMessageFileInfo;
    private MaskableFrameLayout rootContentMessageImage;
    private MaskableFrameLayout frameContentMessageImage;
    private ImageView imageContentMessageImage;
    private ImageView imageContentMessagePlaceHolder;
    private ViewGroup rootContentMessageWebPage;
    private View layoutContentMessageWebDescription;
    private CHTextView textContentMessageWebDescriptionTitle;
    private CHTextView textContentMessageWebDescriptionUrl;
    private View layoutContentMessageWebPreview;
    private ImageView imageContentMessageWebPreview;
    private View rootContentMessageTranslation;
    private LinearLayout buttonContentMessageTranslation;
    private CHTextView textContentMessageTranslation;
    private ImageView viewContentMessageTranslationButtonArrow;
    private CircularProgressView progressContentMessageTranslation;
    private LinearLayout rootExtraContentMessageForm;
    private FormButtonLayout layoutExtraContentMessageFormButton;
    @Nullable
    private OnMessageContentClickListener onMessageContentClickListener;
    @Nullable
    protected Message message;

    protected ContentMessageHolder(View itemView, MessageType messageType, final @Nullable OnMessageContentClickListener onMessageContentClickListener) {
        super(itemView, messageType);
        this.onMessageContentClickListener = onMessageContentClickListener;
        this.rootContentMessageFile = itemView.findViewById(R.id.ch_root_message_content_file);
        this.imageContentMessageFile = (ImageView)itemView.findViewById(R.id.ch_image_message_content_file_icon);
        this.textContentMessageFileName = (CHTextView)itemView.findViewById(R.id.ch_text_message_content_file_name);
        this.textContentMessageFileInfo = (CHTextView)itemView.findViewById(R.id.ch_text_message_content_file_info);
        this.rootContentMessageImage = (MaskableFrameLayout)itemView.findViewById(R.id.ch_root_message_content_image);
        this.imageContentMessageImage = (ImageView)itemView.findViewById(R.id.ch_image_message_content);
        this.imageContentMessagePlaceHolder = (ImageView)itemView.findViewById(R.id.ch_image_message_content_placeholder);
        this.frameContentMessageImage = (MaskableFrameLayout)itemView.findViewById(R.id.ch_frame_message_content_image);
        this.rootContentMessageWebPage = (ViewGroup)itemView.findViewById(R.id.ch_root_message_content_web_page);
        this.layoutContentMessageWebPreview = itemView.findViewById(R.id.ch_layout_message_content_web_preview);
        this.imageContentMessageWebPreview = (ImageView)itemView.findViewById(R.id.ch_image_message_content_web_preview);
        this.layoutContentMessageWebDescription = itemView.findViewById(R.id.ch_layout_message_content_web_description);
        this.textContentMessageWebDescriptionTitle = (CHTextView)itemView.findViewById(R.id.ch_text_message_content_web_description_title);
        this.textContentMessageWebDescriptionUrl = (CHTextView)itemView.findViewById(R.id.ch_text_message_content_web_description_url);
        this.rootContentMessageTranslation = itemView.findViewById(R.id.ch_root_message_content_translation);
        this.buttonContentMessageTranslation = (LinearLayout)itemView.findViewById(R.id.ch_layout_message_content_translation_button);
        this.textContentMessageTranslation = (CHTextView)itemView.findViewById(R.id.ch_text_content_message_translation);
        this.viewContentMessageTranslationButtonArrow = (ImageView)itemView.findViewById(R.id.ch_image_content_message_translation_arrow);
        this.progressContentMessageTranslation = (CircularProgressView)itemView.findViewById(R.id.ch_progress_content_message_translation);
        this.rootExtraContentMessageForm = (LinearLayout)itemView.findViewById(R.id.ch_root_extra_content_form);
        this.layoutExtraContentMessageFormButton = (FormButtonLayout)itemView.findViewById(R.id.ch_layout_extra_content_form_button);
        this.rootContentMessageFile.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (onMessageContentClickListener != null && ContentMessageHolder.this.message != null) {
                    onMessageContentClickListener.onFileClick(ContentMessageHolder.this.message.getFile());
                }
            }
        });
        this.imageContentMessageImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (onMessageContentClickListener != null && ContentMessageHolder.this.message != null && ContentMessageHolder.this.message.getFile() != null) {
                    onMessageContentClickListener.onImageClick(ContentMessageHolder.this.message.getFile());
                }
            }
        });
        this.rootContentMessageWebPage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (onMessageContentClickListener != null && ContentMessageHolder.this.message != null && ContentMessageHolder.this.message.getWebPage() != null) {
                    onMessageContentClickListener.onWebPageClick(ContentMessageHolder.this.message.getWebPage().getUrl());
                }
            }
        });
        if (this.textContentMessageTranslation != null) {
            this.textContentMessageTranslation.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TranslationInfo translationInfo;
                    if (onMessageContentClickListener != null && ContentMessageHolder.this.message != null && ((translationInfo = TranslationSelector.get(TranslationInfo.createId(ContentMessageHolder.this.message.getId(), PrefSupervisor.getPluginLanguage(ContentMessageHolder.this.context)))) == null || translationInfo.getState() != TranslationState.PROGRESS)) {
                        onMessageContentClickListener.onTranslationButtonClick(ContentMessageHolder.this.message);
                    }
                }
            });
        }
    }

    @Override
    public void bind(@Nullable Message message, MessageType messageType, boolean isConnectedMessage) {
        super.bind(message, messageType, isConnectedMessage);
        this.message = message;
    }

    @Override
    protected void resetViews() {
        super.resetViews();
        this.imageContentMessagePlaceHolder.setVisibility(8);
        this.layoutContentMessageWebPreview.setVisibility(8);
        this.layoutContentMessageWebDescription.setVisibility(8);
    }

    protected void setFileDescription(File file) {
        String fileSize = Utils.getProperBytes(file.getSize());
        String fileType = "";
        String extension = file.getExtension();
        if (!"default".equals(extension) && !TextUtils.isEmpty((CharSequence)extension)) {
            fileType = String.format(" \u00b7 %s", extension.substring(0, 1).toUpperCase() + extension.substring(1));
        }
        this.rootContentMessageFile.setVisibility(0);
        this.textContentMessageFileName.setText(file.getFilename());
        this.textContentMessageFileInfo.setText(String.format("%s%s", fileSize, fileType));
        this.imageContentMessageFile.setImageResource(ResUtils.getFileIconResourceId(file));
    }

    protected void setImage(Previewable previewable) {
        if (previewable == null) {
            return;
        }
        this.rootContentMessageImage.setVisibility(0);
        this.imageContentMessagePlaceHolder.setVisibility(0);
        Point previewImageSize = Utils.resizeImage(this.context, new Point(previewable.getWidth().intValue(), previewable.getHeight().intValue()), false);
        Resizer.size((View)this.frameContentMessageImage, previewImageSize.x, previewImageSize.y);
        Glide.with((Context)this.itemView.getContext()).load(previewable.getUrl()).diskCacheStrategy(DiskCacheStrategy.SOURCE).override(previewImageSize.x, previewImageSize.y).centerCrop().listener((RequestListener)new RequestListener<String, GlideDrawable>(){

            public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                ContentMessageHolder.this.imageContentMessagePlaceHolder.setVisibility(8);
                return false;
            }
        }).into(this.imageContentMessageImage);
    }

    protected void setWebPage(WebPage webPage) {
        this.rootContentMessageWebPage.setVisibility(0);
        this.layoutContentMessageWebDescription.setVisibility(0);
        if (!TextUtils.isEmpty((CharSequence)webPage.getTitle())) {
            this.textContentMessageWebDescriptionTitle.setText(webPage.getTitle());
        } else {
            this.textContentMessageWebDescriptionTitle.setText(webPage.getUrl() != null ? webPage.getUrl() : "");
        }
        if (!TextUtils.isEmpty((CharSequence)webPage.getDescription())) {
            this.textContentMessageWebDescriptionUrl.setText(webPage.getTitle());
        } else {
            this.textContentMessageWebDescriptionUrl.setText(webPage.getUrl() != null ? webPage.getUrl() : "");
        }
        if (webPage.getPreviewThumb() != null) {
            this.layoutContentMessageWebPreview.setVisibility(0);
            Point previewImageSize = Utils.resizeImage(this.context, new Point(webPage.getPreviewThumb().getWidth().intValue(), webPage.getPreviewThumb().getHeight().intValue()), true);
            Resizer.size(this.layoutContentMessageWebPreview, previewImageSize.x, previewImageSize.y);
            Glide.with((Context)this.itemView.getContext()).load(webPage.getPreviewThumb().getUrl()).diskCacheStrategy(DiskCacheStrategy.SOURCE).override(previewImageSize.x, previewImageSize.y).centerCrop().into(this.imageContentMessageWebPreview);
        }
    }

    protected void setTranslationButton(Message message, boolean isConnectedMessage) {
        this.rootContentMessageTranslation.setVisibility(0);
        SpannableStringBuilder messageContent = message.getFormattedSpanMessage();
        TranslationInfo translationInfo = TranslationSelector.get(TranslationInfo.createId(message.getId(), PrefSupervisor.getPluginLanguage(this.context)));
        TranslationState translationState = translationInfo == null ? TranslationState.ORIGIN : translationInfo.getState();
        switch (translationState) {
            case ORIGIN: {
                this.setTranslateButtonWithoutProgress("show_translate", false);
                break;
            }
            case TRANSLATED: {
                this.setTranslateButtonWithoutProgress("undo_translate", true);
                if (translationInfo == null) break;
                messageContent = translationInfo.getTranslatedMessage();
                break;
            }
            case PROGRESS: {
                this.buttonContentMessageTranslation.setVisibility(4);
                this.progressContentMessageTranslation.setVisibility(0);
            }
        }
        this.setHostMessageText((CharSequence)messageContent, isConnectedMessage);
    }

    private void setTranslateButtonWithoutProgress(String textKey, boolean isTranslated) {
        this.buttonContentMessageTranslation.setVisibility(0);
        this.progressContentMessageTranslation.setVisibility(8);
        this.textContentMessageTranslation.setTextByKey(textKey);
        Views.setVisibility((View)this.viewContentMessageTranslationButtonArrow, isTranslated);
    }

    protected void setFormMessage(@NonNull Message message) {
        Form form = message.getForm();
        if (form != null && ListUtils.hasItems(form.getInputs())) {
            this.rootExtraContentMessageForm.setVisibility(0);
            this.layoutExtraContentMessageFormButton.removeAllViews();
            this.layoutExtraContentMessageFormButton.refresh();
            this.layoutExtraContentMessageFormButton.setWidth(Utils.getWindowSize((Context)this.context).x - (int)Utils.dpToPx(this.context, 40.0f));
            for (ActionInput actionInput : form.getInputs()) {
                FormButtonView formButtonView = new FormButtonView(this.context, form.getType(), actionInput, this.onMessageContentClickListener);
                this.layoutExtraContentMessageFormButton.add((View)formButtonView);
            }
        }
    }

    protected void setSupportBotMessage(List<ActionInput> actions) {
        if (ListUtils.hasItems(actions)) {
            this.rootExtraContentMessageForm.setVisibility(0);
            this.layoutExtraContentMessageFormButton.removeAllViews();
            this.layoutExtraContentMessageFormButton.refresh();
            this.layoutExtraContentMessageFormButton.setWidth(Utils.getWindowSize((Context)this.context).x - (int)Utils.dpToPx(this.context, 40.0f));
            for (ActionInput actionInput : actions) {
                FormButtonView formButtonView = new FormButtonView(this.context, "supportBot", actionInput, this.onMessageContentClickListener);
                this.layoutExtraContentMessageFormButton.add((View)formButtonView);
            }
        }
    }
}

