/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.overlayheader;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.view.overlayheader.OnHeaderStateChangeListener;
import com.zoyi.channel.plugin.android.activity.chat.view.overlayheader.OverlayHeaderCallback;
import com.zoyi.channel.plugin.android.activity.chat.view.overlayheader.OverlayHeaderState;
import com.zoyi.channel.plugin.android.activity.chat.view.overlayheader.SizeObservableFrameLayout;
import com.zoyi.channel.plugin.android.activity.chat.view.overlayheader.SizeObservableRecyclerView;
import com.zoyi.channel.plugin.android.view.handler.OnSizeChangeListener;

public class OverlayHeaderRecyclerView
extends FrameLayout
implements View.OnTouchListener {
    private SizeObservableRecyclerView recyclerView;
    private SizeObservableFrameLayout bannerFrame;
    private SizeObservableFrameLayout rootFrame;
    @Nullable
    private OverlayHeaderCallback callback;
    @Nullable
    private OnHeaderStateChangeListener listener;
    private OverlayHeaderState state = OverlayHeaderState.HIDDEN;
    private int bannerHeight = 0;
    private float lastTouchY = 0.0f;
    private boolean isBannerAttachedToList = false;

    public OverlayHeaderRecyclerView(Context context) {
        super(context);
        this.init(context);
    }

    public OverlayHeaderRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public OverlayHeaderRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.view_overlay_header_recycler_view, (ViewGroup)this, true);
        this.bannerFrame = (SizeObservableFrameLayout)view.findViewById(R.id.frameOverlayHeaderRecyclerViewHeader);
        this.bannerFrame.setOnSizeChangeListener(new OnSizeChangeListener(){

            @Override
            public void onSizeChange(int width, int height, int oldWidth, int oldHeight) {
                OverlayHeaderRecyclerView.this.bannerHeight = height;
                OverlayHeaderRecyclerView.this.applyTranslationY(height, oldHeight, false);
            }
        });
        this.recyclerView = (SizeObservableRecyclerView)view.findViewById(R.id.recyclerOverlayHeaderRecyclerView);
        this.recyclerView.setOnTouchListener(this);
        this.recyclerView.setOnSizeChangeListener(new OnSizeChangeListener(){

            @Override
            public void onSizeChange(int width, int height, int oldWidth, int oldHeight) {
                OverlayHeaderRecyclerView.this.resolveRecyclerHeight(OverlayHeaderRecyclerView.this.rootFrame.getLastHeight(), OverlayHeaderRecyclerView.this.rootFrame.getLastHeight(), oldHeight, height);
            }
        });
        this.rootFrame = (SizeObservableFrameLayout)view.findViewById(R.id.frameOverlayHeaderRecyclerViewRoot);
        this.rootFrame.setOnTouchListener(this);
        this.rootFrame.setOnSizeChangeListener(new OnSizeChangeListener(){

            @Override
            public void onSizeChange(int width, int height, int oldWidth, int oldHeight) {
                OverlayHeaderRecyclerView.this.resolveRecyclerHeight(oldHeight, height, OverlayHeaderRecyclerView.this.recyclerView.getCalculatedHeight(), OverlayHeaderRecyclerView.this.recyclerView.getCalculatedHeight());
            }
        });
    }

    public void addBannerView(View view) {
        this.bannerFrame.addView(view);
    }

    public void setCallback(OverlayHeaderCallback callback) {
        this.callback = callback;
    }

    public void setListener(OnHeaderStateChangeListener listener) {
        this.listener = listener;
    }

    public boolean isHeaderShown() {
        return this.state == OverlayHeaderState.VISIBLE;
    }

    public RecyclerView getRecyclerView() {
        return this.recyclerView;
    }

    public void toggleBanner() {
        switch (this.state) {
            case HIDDEN: {
                this.state = OverlayHeaderState.VISIBLE;
                this.applyTranslationY(this.bannerHeight, this.bannerHeight, true);
                break;
            }
            case VISIBLE: {
                this.state = OverlayHeaderState.HIDDEN;
                this.applyTranslationY(this.bannerHeight, this.bannerHeight, true);
            }
        }
    }

    public void showBanner(boolean animate) {
        if (this.state == OverlayHeaderState.HIDDEN) {
            this.state = OverlayHeaderState.VISIBLE;
        }
        this.setTranslateY(0.0f, this.bannerHeight, animate);
    }

    public void hideBanner(boolean animate) {
        if (this.state == OverlayHeaderState.VISIBLE) {
            this.state = OverlayHeaderState.HIDDEN;
        }
        this.setTranslateY(-this.bannerHeight, 0.0f, animate);
    }

    private void resolveRecyclerHeight(int oldFrameHeight, int newFrameHeight, int oldRecyclerViewHeight, int newRecyclerViewHeight) {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.recyclerView.getLayoutParams();
        int newRecyclerHeight = Math.min(newFrameHeight, newRecyclerViewHeight);
        int oldRecyclerHeight = params.height;
        params.height = newRecyclerHeight < newFrameHeight ? -2 : newFrameHeight;
        this.recyclerView.setLayoutParams((ViewGroup.LayoutParams)params);
        float recyclerViewTranslationY = this.recyclerView.getTranslationY();
        if (recyclerViewTranslationY > 0.0f && oldRecyclerViewHeight < newRecyclerHeight && oldFrameHeight == newFrameHeight && recyclerViewTranslationY + (float)oldRecyclerViewHeight <= (float)newFrameHeight && recyclerViewTranslationY + (float)newRecyclerHeight > (float)newFrameHeight) {
            float delta = recyclerViewTranslationY + (float)newRecyclerHeight - (float)newFrameHeight;
            this.isBannerAttachedToList = false;
            this.setTranslateY(this.bannerFrame.getTranslationY(), recyclerViewTranslationY - delta);
        }
        if (oldFrameHeight > newFrameHeight) {
            this.hideBanner(true);
        }
        if (oldFrameHeight > newFrameHeight && oldRecyclerHeight == -2 && params.height > 0) {
            this.recyclerView.getLayoutManager().scrollToPosition(this.recyclerView.getAdapter().getItemCount() - 1);
        }
    }

    private void applyTranslationY(int newHeight, int oldHeight, boolean animateOnHide) {
        switch (this.state) {
            case HIDDEN: {
                this.setTranslateY(-newHeight, 0.0f, animateOnHide);
                break;
            }
            case VISIBLE: {
                this.applyBannerAttachmentToList(oldHeight);
                this.setTranslateY(0.0f, this.isBannerAttachedToList ? (float)newHeight : this.recyclerView.getTranslationY(), true);
                break;
            }
            default: {
                this.applyBannerAttachmentToList(oldHeight);
                float bannerTranslateY = Math.max((float)(-newHeight), this.bannerFrame.getTranslationY());
                this.setTranslateY(bannerTranslateY, this.isBannerAttachedToList ? bannerTranslateY + (float)newHeight : Math.min(this.recyclerView.getTranslationY(), (float)newHeight));
            }
        }
    }

    private boolean isScrollOnTop() {
        return !this.recyclerView.canScrollVertically(-1) && (this.callback == null || !this.callback.canScrollTop());
    }

    private boolean isScrollOnBottom() {
        return !this.recyclerView.canScrollVertically(1);
    }

    private void applyBannerAttachmentToList(int targetBannerHeight) {
        boolean isListAttachToBanner = this.bannerFrame.getTranslationY() + (float)targetBannerHeight == this.recyclerView.getTranslationY();
        this.isBannerAttachedToList = (this.isBannerAttachedToList || isListAttachToBanner) && this.isScrollOnTop();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        switch (ev.getActionMasked()) {
            case 0: {
                this.state = OverlayHeaderState.TOUCH_DOWN;
                this.lastTouchY = ev.getRawY();
                break;
            }
            case 1: {
                if (!this.handleTouchUp()) break;
                return true;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                return true;
            }
            case 2: {
                if (this.state == OverlayHeaderState.TOUCH_DOWN) {
                    this.state = OverlayHeaderState.SCROLLING;
                }
                if (this.state == OverlayHeaderState.SCROLLING) {
                    float delta = event.getRawY() - this.lastTouchY;
                    this.lastTouchY = event.getRawY();
                    float bannerTranslation = this.bannerFrame.getTranslationY();
                    float listTranslation = this.recyclerView.getTranslationY();
                    if (this.isScrollOnTop()) {
                        if (delta >= 0.0f) {
                            this.applyBannerAttachmentToList(this.bannerHeight);
                            this.setTranslateY(Math.max(bannerTranslation, listTranslation + delta - (float)this.bannerHeight), listTranslation + delta);
                            return true;
                        }
                        if (delta < 0.0f && listTranslation > 0.0f) {
                            this.applyBannerAttachmentToList(this.bannerHeight);
                            if (this.isBannerAttachedToList) {
                                this.setTranslateY(listTranslation + delta - (float)this.bannerHeight, listTranslation + delta);
                            } else {
                                this.setTranslateY(bannerTranslation, listTranslation + delta);
                            }
                            return true;
                        }
                    }
                }
                this.isBannerAttachedToList = false;
                break;
            }
            case 1: 
            case 3: {
                if (!this.handleTouchUp()) break;
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    private boolean handleTouchUp() {
        if (this.state == OverlayHeaderState.SCROLLING || this.state == OverlayHeaderState.TOUCH_DOWN) {
            boolean handleScroll = this.state == OverlayHeaderState.SCROLLING;
            float bannerTranslationY = this.bannerFrame.getTranslationY();
            this.state = bannerTranslationY > (float)(-this.bannerHeight) / 2.0f ? OverlayHeaderState.VISIBLE : OverlayHeaderState.HIDDEN;
            this.applyTranslationY(this.bannerHeight, this.bannerHeight, true);
            if (handleScroll && this.recyclerView.computeVerticalScrollOffset() == 0) {
                return true;
            }
        }
        return false;
    }

    private void setTranslateY(float bannerTranslateY, float listTranslationY) {
        this.setTranslateY(bannerTranslateY, listTranslationY, false);
    }

    private void setTranslateY(float bannerTranslateY, float listTranslationY, boolean animate) {
        bannerTranslateY = Math.min(0.0f, bannerTranslateY);
        bannerTranslateY = Math.max((float)(-this.bannerHeight), bannerTranslateY);
        listTranslationY = Math.max(0.0f, listTranslationY);
        listTranslationY = Math.min((float)this.bannerHeight, listTranslationY);
        if (this.listener != null) {
            if (bannerTranslateY == 0.0f) {
                this.listener.onBannerShow();
            } else {
                this.listener.onBannerHide();
            }
        }
        if (animate) {
            this.bannerFrame.animate().translationY(bannerTranslateY);
            this.recyclerView.animate().translationY(listTranslationY);
        } else {
            this.bannerFrame.animate().cancel();
            this.recyclerView.animate().cancel();
            this.bannerFrame.setTranslationY(bannerTranslateY);
            this.recyclerView.setTranslationY(listTranslationY);
        }
    }
}

