/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view;

import android.content.Context;
import android.telephony.PhoneNumberFormattingTextWatcher;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnCountryCodeSelectorClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.util.CountryUtils;
import com.zoyi.channel.plugin.android.util.io.Keyboard;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class MobileNumberProfileInputView
extends LinearLayout {
    private Context context;
    private View buttonCountry;
    private CHTextView textCode;
    private WatchedEditText editPhone;
    private boolean inputFocused;
    private int countryCode;

    public MobileNumberProfileInputView(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_mobile_input, (ViewGroup)this);
        this.context = context;
        this.buttonCountry = view.findViewById(R.id.ch_button_profile_item_country);
        this.textCode = (CHTextView)view.findViewById(R.id.ch_text_profile_item_country);
        this.editPhone = (WatchedEditText)view.findViewById(R.id.ch_edit_profile_item_input_phone);
        this.setCountryCode(CountryUtils.getDefaultCountryCodeInt());
    }

    public void setEditTextChangedListener(EditTextChangedListener listener) {
        this.editPhone.setWatchedTextChangedListener(listener);
        this.editPhone.addTextChangedListener((TextWatcher)new PhoneNumberFormattingTextWatcher());
    }

    public void setOnEditorActionListener(TextView.OnEditorActionListener onEditorActionListener) {
        this.editPhone.setOnEditorActionListener(onEditorActionListener);
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener listener) {
        this.editPhone.setOnFocusChangeListener(listener);
    }

    public void setOnCountryCodeSelectorClickListener(final OnCountryCodeSelectorClickListener listener) {
        this.buttonCountry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener != null) {
                    listener.onClick(MobileNumberProfileInputView.this.getMobileNumber());
                }
            }
        });
    }

    public void setImeOption(int imeOption) {
        this.editPhone.setImeOptions(imeOption);
    }

    public void setSelection(int length) {
        this.editPhone.setSelection(length);
    }

    public void setText(String text) {
        this.editPhone.setText(text);
        this.editPhone.setSelection(text.length());
    }

    public boolean isInputFocused() {
        return this.editPhone.isFocused();
    }

    public void requestFocusInputView() {
        this.editPhone.requestFocus();
        Keyboard.open(this.context, (View)this.editPhone);
    }

    public String getPhoneNumber() {
        return this.editPhone.getText().toString();
    }

    public void setCountryCode(int countryCode) {
        this.countryCode = countryCode;
        this.textCode.setText(String.format("+%d", countryCode));
    }

    public MobileNumber getMobileNumber() {
        return new MobileNumber(this.countryCode, this.editPhone.getText().toString());
    }

    public void setMobileNumber(int code, String phoneNumber) {
        this.setCountryCode(code);
        this.editPhone.setText(phoneNumber);
    }

    public void setEnabled(boolean enabled) {
        this.editPhone.setEnabled(enabled);
    }
}

