package com.zoyi.channel.plugin.android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

/**
 * Created by jerry on 2018. 11. 1..
 */

public class ColorFilterImageView extends FrameLayout {

  private View root;
  private MaskableFrameLayout maskColorFilterImageView;
  private View backgroundColorFilterImageView;

  public ColorFilterImageView(@NonNull Context context) {
    super(context);
    init(context, null);
  }

  public ColorFilterImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public ColorFilterImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @Initializer
  public void init(Context context, @Nullable AttributeSet attrs) {
    root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_color_filter_image, this, true);

    maskColorFilterImageView = root.findViewById(R.id.ch_mask_color_filter_image);
    backgroundColorFilterImageView = root.findViewById(R.id.ch_view_color_filter_image_background);

    if (attrs != null) {
      TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ColorFilterImageView, 0, 0);

      try {
        int color = typedArray.getColor(R.styleable.ColorFilterImageView_color, Color.BLACK);
        Drawable image = typedArray.getDrawable(R.styleable.ColorFilterImageView_image);

        setColor(color);
        setImage(image);
      } finally {
        typedArray.recycle();
      }
    }
  }

  public void setImage(@Nullable Drawable image) {
    if (image != null) {
      maskColorFilterImageView.setMask(image);
    }
  }

  public void setColor(int color) {
    backgroundColorFilterImageView.setBackgroundColor(color);
  }
}
